/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	vNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.Common.status.conclusion;

import java.util.Vector;

import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.DataAccess;

/**
 * vNXłB<BR>
 * @author XXX
 * @version 0.0.0.1
 */
public class Conclusion implements ConclusionMessage{

	// CX^Xϐ
	/** vێ܂ */
	private String mstrConclusion;
	/** [UIDێ܂ */
	private String mstrUserID;
	/** LOIDێ܂ */
	private String mstrLoID;
	/** f[^ANZXIuWFNgێ܂B*/
	private DataAccess mobjDataAccess;
	/** p[Xʂێ܂ */
	private DecideConclusion objDecide = null;

	// RXgN^
	/**
	 * vw肵܂B<BR>
	 * v̍\`FbN݂̂sꍇ͂̃RXgN^ĂłB
	 * @param strConclusion v
	 */
	public Conclusion( String strConclusion ) {
		mstrConclusion = strConclusion;
	}

	/**
	 * vсALOIDw肵܂B<BR>
	 * v̍\`FbNсALOID`FbNsꍇ͂̃RXgN^ĂłB
	 * @param strConclusion v
	 * @param strLoID LOID
	 */
	public Conclusion( String strConclusion, String strLoID ) {
		mstrConclusion = strConclusion;
		mstrLoID = strLoID;
	}

	/**
	 * vA[UIDALOIDw肵܂B<BR>
	 * p[XsāAv𖞂Ă邩`FbNꍇ͂̃RXgN^ĂłB
	 * @param strConclusion v
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param objDataAccess f[^ANZXIuWFNg
	 */
	public Conclusion( String strConclusion, String strUserID, String strLoID, DataAccess objDataAccess ) {
		mstrConclusion = strConclusion;
		mstrUserID = strUserID;
		mstrLoID = strLoID;
		mobjDataAccess = objDataAccess;
	}

	// O\bh
	/**
	 * v͂܂B
	 * @exception ConclusionParseException v̍\Ɍ肪ꍇ
	 * @exception ConclusionException ͒ɎsOꍇ
	 */
	public void parse()
		throws ConclusionParseException,ConclusionException
	{
		if ( mstrConclusion == null || mstrConclusion.equals("") ){
			throw new ConclusionParseException( ConclusionEnv.getMessage( INPUT_EMPTY_ERR ) );
		}
		ConclusionData objCd = new ConclusionData( mstrConclusion, mstrUserID, mobjDataAccess );
		ConclusionNode objCn = new ConclusionNode( objCd );
		objCn.parse();
		objDecide = (DecideConclusion)objCn;
	}

	/**
	 * v̑Ó`FbNs܂B<BR>
	 * ȉ̂悤ȃ`FbNs肪ꍇ́AConclusionParseExceptionX[܂B<BR>
	 * <PRE>
	 *       @@\`FbN@\łĂ邩`FbN
	 *       A@LOID`FbN@RXgN^ŁALOIDw肳ĂꍇA
	 *                         w肳ꂽLOIĎZIDAqID݂̂gpĂ邱Ƃ`FbN܂B
	 * </PRE>
	 * @exception ConclusionParseException v̍\Ɍ肪ꍇ
	 * @exception ConclusionException ͒ɎsOꍇ
	 */
	public void check(boolean bInsMode)
		throws ConclusionParseException,ConclusionException
	{
		try
		{
			if ( mstrConclusion == null || mstrConclusion.equals("") ){
				throw new ConclusionParseException( ConclusionEnv.getMessage( INPUT_EMPTY_ERR ) );
			}
			ConclusionData objCd = new ConclusionData( mstrConclusion, mstrUserID, mobjDataAccess );
			ConclusionNode objCn = new ConclusionNode( objCd );
			objCn.parse();
			objDecide = (DecideConclusion)objCn;

			//LOID`FbN
			if ( mstrLoID != null ){
				Vector vecConclusion = objDecide.getLoIDList();
				if ( vecConclusion.size() == 0 ){
					throw new ConclusionParseException( ConclusionEnv.getMessage( LOID_LIST_NONE ) );
				}
				Vector vecCheck = getChildList( mstrLoID );//qLOID擾
				if ( vecCheck.containsAll( vecConclusion ) != true ){
					DebugLog.write( this.getClass(), vecCheck, DebugLog.ROW );
					DebugLog.write( this.getClass(), vecConclusion, DebugLog.ROW );
					throw new ConclusionParseException( ConclusionEnv.getMessage( LOID_CHECK_ERR ) );
				}
			}
		}
		catch( ConclusionParseException pe)
		{
			DebugLog.write( this.getClass(), pe, DebugLog.ROW );
			throw pe;
		}
		catch( ConclusionException ce)
		{
			DebugLog.write( this.getClass(), ce, DebugLog.ROW );
			throw ce;
		}
	}

	/**
	 * v𖞂Ă邩Ԃ܂B
	 * @return boolean true: Ă false: ĂȂ
	 * @exception ConclusionException vp[XĂȂƂȂ
	 */
	public boolean isConcluded()
		throws ConclusionException
	{
		return objDecide.isConcluded();
	}

	/**
	 * vŎgpĂLOID̈ꗗ擾܂
	 * @return String[] LOIDꗗ
	 * @exception ConclusionParseException v̍\Ɍ肪ꍇ
	 * @exception ConclusionException ͒ɎsOꍇ
	 */
	public String[] getLoIDList()
		throws ConclusionParseException,ConclusionException
	{
		if ( objDecide == null ){
			parse();
		}
		Vector vecTemp = objDecide.getLoIDList();
		if ( vecTemp.size() == 0 ){
			return new String[0];
		}
		else{
			String[] result = new String[vecTemp.size()];
			vecTemp.copyInto( result );
			return result;
		}
	}

	/**
	 * vɎw肳ꂽLOIDgpĂ邩ǂ𒲂ׂ܂B
	 * @param strLoID rΏLOID
	 * @return boolean true:gpĂ false: gpĂȂ
	 * @exception ConclusionParseException v̍\Ɍ肪ꍇ
	 * @exception ConclusionException ͒ɎsOꍇ
	 */
	public boolean isUsedLoID( String strLoID )
		throws ConclusionParseException,ConclusionException
	{
		if ( objDecide == null ){
			parse();
		}
		Vector vecTemp = objDecide.getLoIDList();
		return vecTemp.contains( strLoID );
	}



	/**
	 * LOIDeLOID擾郁\bhłB
	 * @exception ConclusionException `O
	 */
	private String getParentID(String strLoID)
		throws ConclusionException
	{
		String strParentID = null;
		try {
			LoRelationClient objLoRelation = new LoRelationClient();
			// ɎqLOIDw肵܂
			objLoRelation.setWhereChildID( strLoID );
			// 
			if( !objLoRelation.select() ) {
				// Ɏsꍇ
				throw new ConclusionException( objLoRelation.getMessage() );
			}

			// ʂ擾
			if( objLoRelation.next() ) {
				strParentID = objLoRelation.getParentID();
			}
		}
		catch(ConclusionException pe) {
			throw pe;
		}
		catch(Exception ex) {
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			throw new ConclusionException(ex.getMessage());
		}
		return strParentID;
	}

	/**
	 * w肳ꂽLOID̎qIDXg擾܂B
	 * @param strParentID eID
	 * @return Vector qIDXg
	 * @exception ConclusionException `O
	 */
	private Vector getChildList(String strParentID)
		throws ConclusionException
	{
		Vector vecChildList = new Vector();
		try {
			LoRelationClient objLoRelation = new LoRelationClient();
			// ɐeLOIDw肵܂
			objLoRelation.setWhereParentID( strParentID );
			// 
			if( !objLoRelation.select() ) {
				// Ɏsꍇ
				throw new ConclusionException( objLoRelation.getMessage() );
			}

			// ʂ擾
			while( objLoRelation.next() ) {
				String strChildID = objLoRelation.getChildID();
				vecChildList.add( objLoRelation.getChildID() );
			}
		}
		catch(ConclusionException pe) {
			throw pe;
		}
		catch(Exception ex) {
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			throw new ConclusionException(ex.getMessage());
		}
		return vecChildList;
	}

}


