/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseMessages;
import java.sql.SQLException;
import java.sql.SQLWarning;

public final class BaseWarnings {
    private static String footprint = "$Revision:   1.4.1.0  $";
    private BaseMessages baseMessages;
    private BaseWarning firstWarning;
    private BaseWarning lastWarning;

    public BaseWarnings(String string) throws SQLException {
        this.baseMessages = new BaseMessages(string);
        this.firstWarning = null;
        this.lastWarning = null;
    }

    public void add(int n) {
        BaseWarning baseWarning = new BaseWarning(n, null, null, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String string) {
        BaseWarning baseWarning = new BaseWarning(n, null, string, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String string, int n2) {
        BaseWarning baseWarning = new BaseWarning(n, null, string, new Integer(n2));
        this.addToList(baseWarning);
    }

    public void add(int n, String[] stringArray) {
        BaseWarning baseWarning = new BaseWarning(n, stringArray, null, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String[] stringArray, String string) {
        BaseWarning baseWarning = new BaseWarning(n, stringArray, string, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String[] stringArray, String string, int n2) {
        BaseWarning baseWarning = new BaseWarning(n, stringArray, string, new Integer(n2));
        this.addToList(baseWarning);
    }

    private void addToList(BaseWarning baseWarning) {
        if (this.firstWarning == null) {
            this.firstWarning = baseWarning;
        }
        if (this.lastWarning != null) {
            this.lastWarning.setNextWarning(baseWarning);
        }
        this.lastWarning = baseWarning;
    }

    public void clear() {
        this.firstWarning = null;
        this.lastWarning = null;
    }

    public SQLWarning createSQLWarning(BaseWarning baseWarning) {
        if (baseWarning == null) {
            return null;
        }
        SQLWarning sQLWarning = null;
        String string = "";
        if (baseWarning.SQLstate != null) {
            string = baseWarning.SQLstate;
        }
        sQLWarning = baseWarning.vendorCode != null ? new SQLWarning(this.baseMessages.getMessage(baseWarning.reasonKey, baseWarning.reasonArgs, true), string, baseWarning.vendorCode) : new SQLWarning(this.baseMessages.getMessage(baseWarning.reasonKey, baseWarning.reasonArgs, false), string);
        sQLWarning.setNextWarning(this.createSQLWarning(baseWarning.nextWarning));
        return sQLWarning;
    }

    public SQLWarning get() {
        return this.createSQLWarning(this.firstWarning);
    }

    private class BaseWarning {
        int reasonKey;
        String[] reasonArgs;
        String SQLstate;
        Integer vendorCode;
        BaseWarning nextWarning = null;

        public BaseWarning(int n, String[] stringArray, String string, Integer n2) {
            this.reasonKey = n;
            this.reasonArgs = stringArray;
            this.SQLstate = string;
            this.vendorCode = n2;
        }

        public void setNextWarning(BaseWarning baseWarning) {
            this.nextWarning = baseWarning;
        }
    }
}

