/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.BuilderErrorHandler;
import org.jdom.input.JDOMFactory;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: SAXBuilder.java,v $ $Revision: 1.75 $ $Date: 2003/04/10 04:38:47 $ $Name: jdom_1_0_b9_rc2 $";
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private boolean expand = true;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    protected JDOMFactory factory = null;
    private boolean ignoringWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);
    private boolean reuseParser = false;
    private XMLReader saxParser = null;
    static /* synthetic */ Class class$java$util$Map;

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean validate) {
        this.validate = validate;
    }

    public SAXBuilder(String saxDriverClass) {
        this(saxDriverClass, false);
    }

    public SAXBuilder(String saxDriverClass, boolean validate) {
        this.saxDriverClass = saxDriverClass;
        this.validate = validate;
    }

    public void setFactory(JDOMFactory factory) {
        this.factory = factory;
    }

    public void setValidation(boolean validate) {
        this.validate = validate;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.saxDTDHandler = dtdHandler;
    }

    public void setXMLFilter(XMLFilter xmlFilter) {
        this.saxXMLFilter = xmlFilter;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.ignoringWhite = ignoringWhite;
    }

    public void setReuseParser(boolean reuseParser) {
        this.reuseParser = reuseParser;
        this.saxParser = null;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Document build(InputSource in) throws JDOMException, IOException {
        SAXHandler contentHandler = null;
        try {
            try {
                Object root;
                contentHandler = this.createContentHandler();
                this.configureContentHandler(contentHandler);
                XMLReader parser = this.saxParser;
                if (parser == null) {
                    parser = this.createParser();
                    if (this.saxXMLFilter != null) {
                        root = this.saxXMLFilter;
                        while (root.getParent() instanceof XMLFilter) {
                            root = (XMLFilter)root.getParent();
                        }
                        root.setParent(parser);
                        parser = this.saxXMLFilter;
                    }
                    this.configureParser(parser, contentHandler);
                    if (this.reuseParser) {
                        this.saxParser = parser;
                    }
                } else {
                    parser.setContentHandler(contentHandler);
                }
                parser.parse(in);
                root = contentHandler.getDocument();
                Object var6_8 = null;
                contentHandler = null;
                return root;
            }
            catch (SAXParseException e) {
                String systemId = e.getSystemId();
                if (systemId != null) {
                    throw new JDOMParseException("Error on line " + e.getLineNumber() + " of document " + systemId, contentHandler.getDocument(), e);
                }
                throw new JDOMParseException("Error on line " + e.getLineNumber(), contentHandler.getDocument(), e);
            }
            catch (SAXException e) {
                throw new JDOMParseException("Error in building: " + e.getMessage(), contentHandler.getDocument(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            contentHandler = null;
            throw throwable;
        }
    }

    protected SAXHandler createContentHandler() {
        SAXHandler contentHandler = new SAXHandler(this.factory);
        return contentHandler;
    }

    protected void configureContentHandler(SAXHandler contentHandler) {
        contentHandler.setExpandEntities(this.expand);
        contentHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
    }

    protected XMLReader createParser() throws JDOMException {
        XMLReader parser = null;
        if (this.saxDriverClass != null) {
            try {
                parser = XMLReaderFactory.createXMLReader(this.saxDriverClass);
                this.setFeaturesAndProperties(parser, true);
            }
            catch (SAXException e) {
                throw new JDOMException("Could not load " + this.saxDriverClass, e);
            }
        }
        try {
            Class<?> factoryClass = Class.forName("org.jdom.input.JAXPParserFactory");
            Method createParser = factoryClass.getMethod("createParser", Boolean.TYPE, class$java$util$Map == null ? (class$java$util$Map = SAXBuilder.class$("java.util.Map")) : class$java$util$Map, class$java$util$Map == null ? (class$java$util$Map = SAXBuilder.class$("java.util.Map")) : class$java$util$Map);
            parser = (XMLReader)createParser.invoke(null, new Boolean(this.validate), this.features, this.properties);
            this.setFeaturesAndProperties(parser, false);
        }
        catch (JDOMException e) {
            throw e;
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            // empty catch block
        }
        if (parser == null) {
            try {
                parser = XMLReaderFactory.createXMLReader(DEFAULT_SAX_DRIVER);
                this.saxDriverClass = parser.getClass().getName();
                this.setFeaturesAndProperties(parser, true);
            }
            catch (SAXException e) {
                throw new JDOMException("Could not load default SAX parser: org.apache.xerces.parsers.SAXParser", e);
            }
        }
        return parser;
    }

    protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
        block15: {
            parser.setContentHandler(contentHandler);
            if (this.saxEntityResolver != null) {
                parser.setEntityResolver(this.saxEntityResolver);
            }
            if (this.saxDTDHandler != null) {
                parser.setDTDHandler(this.saxDTDHandler);
            } else {
                parser.setDTDHandler(contentHandler);
            }
            if (this.saxErrorHandler != null) {
                parser.setErrorHandler(this.saxErrorHandler);
            } else {
                parser.setErrorHandler(new BuilderErrorHandler());
            }
            boolean lexicalReporting = false;
            try {
                parser.setProperty("http://xml.org/sax/handlers/LexicalHandler", contentHandler);
                lexicalReporting = true;
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException e) {
                // empty catch block
            }
            if (!lexicalReporting) {
                try {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
                    lexicalReporting = true;
                }
                catch (SAXNotSupportedException e) {
                }
                catch (SAXNotRecognizedException e) {
                    // empty catch block
                }
            }
            if (this.expand) break block15;
            try {
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", contentHandler);
            }
            catch (SAXNotSupportedException e) {
            }
            catch (SAXNotRecognizedException e) {}
        }
    }

    private void setFeaturesAndProperties(XMLReader parser, boolean coreFeatures) throws JDOMException {
        String name;
        Iterator iter = this.features.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            Boolean value = (Boolean)this.features.get(name);
            this.internalSetFeature(parser, name, value, name);
        }
        iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            this.internalSetProperty(parser, name, this.properties.get(name), name);
        }
        if (coreFeatures) {
            block9: {
                try {
                    this.internalSetFeature(parser, "http://xml.org/sax/features/validation", this.validate, "Validation");
                }
                catch (JDOMException e) {
                    if (!this.validate) break block9;
                    throw e;
                }
            }
            this.internalSetFeature(parser, "http://xml.org/sax/features/namespaces", true, "Namespaces");
            this.internalSetFeature(parser, "http://xml.org/sax/features/namespace-prefixes", true, "Namespace prefixes");
        }
        try {
            if (parser.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException e) {}
    }

    private void internalSetFeature(XMLReader parser, String feature, boolean value, String displayName) throws JDOMException {
        try {
            parser.setFeature(feature, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " feature not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " feature not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader parser, String property, Object value, String displayName) throws JDOMException {
        try {
            parser.setProperty(property, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " property not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " property not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    public Document build(InputStream in) throws JDOMException, IOException {
        return this.build(new InputSource(in));
    }

    public Document build(File file) throws JDOMException, IOException {
        try {
            URL url = this.fileToURL(file);
            return this.build(url);
        }
        catch (MalformedURLException e) {
            throw new JDOMException("Error in building", e);
        }
    }

    public Document build(URL url) throws JDOMException, IOException {
        String systemID = url.toExternalForm();
        return this.build(new InputSource(systemID));
    }

    public Document build(InputStream in, String systemId) throws JDOMException, IOException {
        InputSource src = new InputSource(in);
        src.setSystemId(systemId);
        return this.build(src);
    }

    public Document build(Reader characterStream) throws JDOMException, IOException {
        return this.build(new InputSource(characterStream));
    }

    public Document build(Reader characterStream, String systemId) throws JDOMException, IOException {
        InputSource src = new InputSource(characterStream);
        src.setSystemId(systemId);
        return this.build(src);
    }

    public Document build(String systemId) throws JDOMException, IOException {
        return this.build(new InputSource(systemId));
    }

    protected URL fileToURL(File f) throws MalformedURLException {
        String path = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && f.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public void setExpandEntities(boolean expand) {
        this.expand = expand;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

