/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.validator.CreditCardValidator;
import org.apache.commons.validator.DateValidator;
import org.apache.commons.validator.EmailValidator;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.oro.text.perl.Perl5Util;

public class GenericValidator
implements Serializable {
    public static final String REGEXP_DELIM = "/";
    private static final UrlValidator urlValidator = new UrlValidator();
    private static final CreditCardValidator creditCardValidator = new CreditCardValidator();

    public static boolean isBlankOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean matchRegexp(String value, String regexp) {
        if (regexp == null || regexp.length() <= 0) {
            return false;
        }
        Perl5Util matcher = new Perl5Util();
        return matcher.match(REGEXP_DELIM + regexp + REGEXP_DELIM, value);
    }

    public static boolean isByte(String value) {
        return GenericTypeValidator.formatByte(value) != null;
    }

    public static boolean isShort(String value) {
        return GenericTypeValidator.formatShort(value) != null;
    }

    public static boolean isInt(String value) {
        return GenericTypeValidator.formatInt(value) != null;
    }

    public static boolean isLong(String value) {
        return GenericTypeValidator.formatLong(value) != null;
    }

    public static boolean isFloat(String value) {
        return GenericTypeValidator.formatFloat(value) != null;
    }

    public static boolean isDouble(String value) {
        return GenericTypeValidator.formatDouble(value) != null;
    }

    public static boolean isDate(String value, Locale locale) {
        return DateValidator.getInstance().isValid(value, locale);
    }

    public static boolean isDate(String value, String datePattern, boolean strict) {
        return DateValidator.getInstance().isValid(value, datePattern, strict);
    }

    public static boolean isInRange(byte value, byte min, byte max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(float value, float min, float max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(short value, short min, short max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(long value, long min, long max) {
        return value >= min && value <= max;
    }

    public static boolean isInRange(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public static boolean isCreditCard(String value) {
        return creditCardValidator.isValid(value);
    }

    protected static boolean validateCreditCardLuhnCheck(String cardNumber) {
        return new CreditCardValidator().luhnCheck(cardNumber);
    }

    protected boolean validateCreditCardPrefixCheck(String cardNumber) {
        return new CreditCardValidator().isValidPrefix(cardNumber);
    }

    public static boolean isEmail(String value) {
        return EmailValidator.getInstance().isValid(value);
    }

    public static boolean isUrl(String value) {
        return urlValidator.isValid(value);
    }

    public static boolean maxLength(String value, int max) {
        return value.length() <= max;
    }

    public static boolean minLength(String value, int min) {
        return value.length() >= min;
    }

    protected static String getDelimittedRegexp(String regexp) {
        return ValidatorUtil.getDelimitedRegExp(regexp);
    }
}

