/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.core.util;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerOverwriteXmlValue;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerFileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;
import jp.co.ntt.lms.installer.util.XmlUtil;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InstallerXmlUtil {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$core$util$InstallerXmlUtil == null ? (class$jp$co$ntt$lms$installer$core$util$InstallerXmlUtil = InstallerXmlUtil.class$("jp.co.ntt.lms.installer.core.util.InstallerXmlUtil")) : class$jp$co$ntt$lms$installer$core$util$InstallerXmlUtil);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$core$util$InstallerXmlUtil;

    public static Document load(InstallerValues installerValues, String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "load(" + string + ")");
        Document document = null;
        InputStream inputStream = null;
        boolean bl = false;
        try {
            inputStream = installerValues.getResourceKeyStream(string);
            document = XmlUtil.convertXmlStreamToDocument(inputStream);
            bl = true;
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        finally {
            InstallerFileUtil.close(inputStream, bl);
        }
        LoggerUtil.methodTail(_logger, "load(" + string + ")");
        return document;
    }

    public static String determineInitialNodeValue(Document document, Document document2, String string) throws InstallerException {
        LoggerUtil.methodHead(_logger, "determineInitialNodeValue(" + document + "," + document2 + "," + string + ")");
        Object object = null;
        try {
            if (document != null) {
                String string2 = XmlUtil.getNodeValue(document, string);
                String string3 = XmlUtil.getNodeValue(document2, string);
                object = StringUtil.isEmpty(string2) ? null : (StringUtil.isEmpty(string3) ? string2 : (string2.equals(string3) ? null : string2));
            }
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "determineInitialNodeValue(" + document + "," + document2 + "," + string + ")", object);
        return object;
    }

    public static void overwriteXml(InstallerValues installerValues, InstallerOverwriteXmlValue installerOverwriteXmlValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "overwriteXml(InstallerValues," + installerOverwriteXmlValue + ")");
        try {
            Object object;
            Object object2;
            Object object3;
            Document document = InstallerXmlUtil.load(installerValues, installerOverwriteXmlValue.getTargetFileKey());
            Properties properties = installerOverwriteXmlValue.getOverwrittenNodeValues(installerValues);
            if (properties != null) {
                object3 = properties.keySet();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    _logger.info("Node XPath:[" + (String)object + "]");
                    String string = properties.getProperty((String)object);
                    _logger.info("Node Value:[" + string + "]");
                    Node node = XPathAPI.selectSingleNode((Node)document, (String)object);
                    if (node == null) {
                        _logger.info("selectSingleNode[" + (String)object + "] is Null");
                        continue;
                    }
                    node.setNodeValue(string);
                }
            }
            object3 = installerValues.getFileOnSystem(installerOverwriteXmlValue.getTargetFileKey());
            _logger.info("XML Output target[" + object3 + "]");
            object2 = installerValues.getProperty(installerOverwriteXmlValue.getXmlFileEncodeKey());
            object = new Properties();
            if (object2 != null) {
                ((Properties)object).setProperty("encoding", (String)object2);
            }
            XmlUtil.convertDocumentToFile(document, (File)object3, (Properties)object);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "overwriteXml(InstallerValues," + installerOverwriteXmlValue + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

