/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	CachedNode
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm.util;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.xml.transform.TransformerException;

import org.w3c.dom.Node;

/**
 *	CachedNode NX<br>
 *	Nodeɑ΂XPath̎擾ʂLbV<br>
 */
public class CachedNode {

	/** null */
	private static CachedNode[] __null = new CachedNode[0];

	/** null */
	private static CachedNode _null = new CachedNode();

	/** ArrayListCachedNode[]ɕϊׂCachedNode[0] */
	private static CachedNode[] _toSingleArray = new CachedNode[0];

	/** LbVm[h */
	private Node node;

	/** XPathƒPm[hI(CacheNode)̃}bv */
	private Hashtable nodeCache = new Hashtable();

	/** XPathƕm[hI(CacheNode[])̃}bv */
	private Hashtable nodesCache = new Hashtable();

	/**
	 * ftHgRXgN^
	 */
	private CachedNode() {}

	/**
	 * RXgN^
	 *
	 * @param node	xpatȟΏۂƂm[hw肷
	 */
	public CachedNode(Node node) {
		this.node = node;
	}

	/**
	 * m[h擾
	 *
	 * @return RXgN^Ŏw肳ꂽNodeԋp
	 */
	public Node getNode() {
		return node;
	}

	/**
	 * m[h̒l擾
	 *
	 * @return RXgN^Ŏw肳ꂽNodegetNodeValue\bh̖߂lԋp
	 */
	public String getNodeValue() {
		return node.getNodeValue();
	}

	/**
	 * node畡m[hIALbV
	 *
	 * @param	xpath	sXPathw肷
	 * @return	XPathAPI#selectNodeListIłm[hCachedNode[]B
	 *			XPathAPI#selectNodeListnullԋpꍇnullԋp
	 */
	public CachedNode[] selectNodeList(String xpath) throws TransformerException {
		return selectNodeList(xpath, true);
	}

	/**
	 * node畡m[hIB
	 * cachep[^truȅꍇ͑IʂLbV<br>
	 * cachep[^falsȅꍇ͑Iʂ̃LbVsȂ<br>
	 *
	 * @param	xpath	sXPathw肷
	 * @param	cache	ʂLbV邩ǂw肷B
	 *					truew肳ꂽꍇ̓LbVBfalsew肳ꂽꍇ̓LbVȂB
	 * @return	XPathAPI#selectSingleNodeIłNodeCachedNodeB
	 *			XPathAPI#selectSingleNodenullԋpꍇnullԋp
	 */
	public CachedNode[] selectNodeList(String xpath, boolean cache) throws TransformerException {
		CachedNode[] cachedNodes = (CachedNode[])nodesCache.get(xpath);

		if (cachedNodes != null) {
			if (cachedNodes == __null) {
				return null;
			}

			return cachedNodes;
		}

		Node[] nodes = XPathUtil.selectNodeList(node, xpath);

		if (nodes == null) {
			nodesCache.put(xpath, __null);
			nodeCache.put(xpath, _null);

			return null;
		}

		cachedNodes = new CachedNode[nodes.length];

		for (int i = 0; i < cachedNodes.length; i++) {
			cachedNodes[i] = new CachedNode(nodes[i]);
		}

		if (cache) {
			nodesCache.put(xpath, cachedNodes);
			nodeCache.put(xpath, (cachedNodes.length >= 1) ? cachedNodes[0] : _null);
		}

		return cachedNodes;
	}

	/**
	 * node畡m[hIALbV
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSimpleNodeList
	 *					w\ȎɌ肳
	 * @return	XPathUtil#selectSimpleNodeListIłm[hCachedNode[]B
	 *			XPathUtil#selectSimpleNodeListnullԋpꍇnullԋp
	 */
	public CachedNode[] selectSimpleNodeList(String xpath) {
		return selectSimpleNodeList(xpath, true);
	}

	/**
	 * node畡m[hIB
	 * cachep[^truȅꍇ͑IʂLbV<br>
	 * cachep[^falsȅꍇ͑Iʂ̃LbVsȂ<br>
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSimpleNodeList
	 *					w\ȎɌ肳
	 * @param	cache	ʂLbV邩ǂw肷B
	 *					truew肳ꂽꍇ̓LbVBfalsew肳ꂽꍇ̓LbVȂB
	 * @return	XPathUtil#selectSimpleNodeListIłNodeCachedNodeB
	 *			XPathUtil#selectSimpleNodeListnullԋpꍇnullԋp
	 */
	public CachedNode[] selectSimpleNodeList(String xpath, boolean cache) {
		CachedNode[] cachedNodes = (CachedNode[])nodesCache.get(xpath);

		if (cachedNodes != null) {
			if (cachedNodes == __null) {
				return null;
			}

			return cachedNodes;
		}

		Node[] result = XPathUtil.selectSimpleNodeList(node, xpath);

		if (result == null) {
			nodesCache.put(xpath, __null);
			nodeCache.put(xpath, _null);

			return null;
		}

		cachedNodes = new CachedNode[result.length];

		for (int i = 0; i < cachedNodes.length; i++) {
			cachedNodes[i] = new CachedNode(result[i]);
		}

		if (cache) {
			nodesCache.put(xpath, cachedNodes);
			nodeCache.put(xpath, (cachedNodes.length >= 1) ? cachedNodes[0] : _null);
		}

		return cachedNodes;
	}

	/**
	 * node̎qm[h畡m[hIALbV
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectChildNodeList
	 *					w\ȎɌ肳
	 * @return	XPathAPI#selectChildNodeListIłm[hCachedNode[]B
	 *			XPathAPI#selectChildNodeListnullԋpꍇnullԋp
	 */
	public CachedNode[] selectChildNodeList(String xpath) {
		return selectChildNodeList(xpath, true);
	}

	/**
	 * node̎qm[h畡m[hIB
	 * cachep[^truȅꍇ͑IʂLbV<br>
	 * cachep[^falsȅꍇ͑Iʂ̃LbVsȂ<br>
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectChildNodeList
	 *					w\ȎɌ肳
	 * @param	cache	ʂLbV邩ǂw肷B
	 *					truew肳ꂽꍇ̓LbVBfalsew肳ꂽꍇ̓LbVȂB
	 * @return	XPathUtil#selectChildNodeListIłNodeCachedNodeB
	 *			XPathUtil#selectChildNodeListnullԋpꍇnullԋp
	 */
	public CachedNode[] selectChildNodeList(String xpath, boolean cache) {
		CachedNode[] cachedNodes = (CachedNode[])nodesCache.get(xpath);

		if (cachedNodes != null) {
			if (cachedNodes == __null) {
				return null;
			}

			return cachedNodes;
		}

		Node[] result = XPathUtil.selectChildNodeList(node, xpath);

		if (result == null) {
			nodesCache.put(xpath, __null);
			nodeCache.put(xpath, _null);

			return null;
		}

		cachedNodes = new CachedNode[result.length];

		for (int i = 0; i < cachedNodes.length; i++) {
			cachedNodes[i] = new CachedNode(result[i]);
		}

		if (cache) {
			nodesCache.put(xpath, cachedNodes);
			nodeCache.put(xpath, (cachedNodes.length >= 1) ? cachedNodes[0] : _null);
		}

		return cachedNodes;
	}

	/**
	 * nodePm[hIALbV
	 *
	 * @param	xpath	sXPathw肷
	 * @return	XPathAPI#selectSingleNodeIłNodeCachedNodeB
	 *			XPathAPI#selectSingleNodenullԋpꍇnullԋp
	 */
	public CachedNode selectSingleNode(String xpath) throws TransformerException {
		return selectSingleNode(xpath, true);
	}

	/**
	 * nodePm[hIB<br>
	 * cachep[^truȅꍇ͑IʂLbV<br>
	 * cachep[^falsȅꍇ͑Iʂ̃LbVsȂ<br>
	 *
	 * @param	xpath	sXPathw肷
	 * @param	cache	ʂLbV邩ǂw肷B
	 *					truew肳ꂽꍇ̓LbVBfalsew肳ꂽꍇ̓LbVȂB
	 * @return	XPathAPI#selectSingleNodeIłNodeCachedNodeB
	 *			XPathAPI#selectSingleNodenullԋpꍇnullԋp
	 */
	public CachedNode selectSingleNode(String xpath, boolean cache) throws TransformerException {
		CachedNode cachedNode = (CachedNode)nodeCache.get(xpath);

		if (cachedNode != null) {
			if (cachedNode == _null) {
				return null;
			}

			return cachedNode;
		}

		Node result = XPathUtil.selectSingleNode(node, xpath);

		if (result == null) {
			nodeCache.put(xpath, _null);
			return null;
		}

		cachedNode = new CachedNode(result);

		if (cache) {
			nodeCache.put(xpath, cachedNode);
		}

		return cachedNode;
	}

	/**
	 * nodePm[hIALbV
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSimpleSingleNode
	 *					w\ȎɌ肳
	 * @return	XPathUtil#selectSimpleSingleNodeIłNodeCachedNodeB
	 *			XPathUtil#selectSimpleSingleNodenullԋpꍇnullԋp
	 */
	public CachedNode selectSimpleSingleNode(String xpath) {
		return selectSimpleSingleNode(xpath, true);
	}

	/**
	 * node畡m[hIB
	 * cachep[^truȅꍇ͑IʂLbV<br>
	 * cachep[^falsȅꍇ͑Iʂ̃LbVsȂ<br>
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSimpleSingleNode
	 *					w\ȎɌ肳
	 * @param	cache	ʂLbV邩ǂw肷B
	 *					truew肳ꂽꍇ̓LbVBfalsew肳ꂽꍇ̓LbVȂB
	 * @return	XPathUtil#selectSimpleSingleNodeIłNodeCachedNodeB
	 *			XPathUtil#selectSimpleSingleNodenullԋpꍇnullԋp
	 */
	public CachedNode selectSimpleSingleNode(String xpath, boolean cache) {
		CachedNode cachedNode = (CachedNode)nodeCache.get(xpath);

		if (cachedNode != null) {
			if (cachedNode == _null) {
				return null;
			}

			return cachedNode;
		}

		Node result = XPathUtil.selectSimpleSingleNode(node, xpath);

		if (result == null) {
			nodeCache.put(xpath, _null);
			return null;
		}

		cachedNode = new CachedNode(result);

		if (cache) {
			nodeCache.put(xpath, cachedNode);
		}

		return cachedNode;
	}

	/**
	 * node̎qm[h畡m[hIALbV
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSingleChildNode
	 *					w\ȎɌ肳
	 * @return	XPathAPI#selectSingleChildNodeIłm[hCachedNode[]B
	 *			XPathAPI#selectSingleChildNodenullԋpꍇnullԋp
	 */
	public CachedNode selectSingleChildNode(String xpath) {
		return selectSingleChildNode(xpath, true);
	}

	/**
	 * node̎qm[h畡m[hIB
	 * cachep[^truȅꍇ͑IʂLbV<br>
	 * cachep[^falsȅꍇ͑Iʂ̃LbVsȂ<br>
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSingleChildNode
	 *					w\ȎɌ肳
	 * @param	cache	ʂLbV邩ǂw肷B
	 *					truew肳ꂽꍇ̓LbVBfalsew肳ꂽꍇ̓LbVȂB
	 * @return	XPathUtil#selectSingleChildNodeIłNodeCachedNodeB
	 *			XPathUtil#selectSingleChildNodenullԋpꍇnullԋp
	 */
	public CachedNode selectSingleChildNode(String xpath, boolean cache) {
		CachedNode cachedNode = (CachedNode)nodeCache.get(xpath);

		if (cachedNode != null) {
			if (cachedNode == _null) {
				return null;
			}

			return cachedNode;
		}

		Node result = XPathUtil.selectSingleChildNode(node, xpath);

		if (result == null) {
			nodeCache.put(xpath, _null);
			return null;
		}

		cachedNode = new CachedNode(result);

		if (cache) {
			nodeCache.put(xpath, cachedNode);
		}

		return cachedNode;
	}

	/**
	 * ȉXPathƓʂ̌sA(ŏɌ)P̃m[hԋp<br>
	 *
	 * 1.valueOfMatchnullłȂꍇ<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;%xpath%[%xpathOfTestExpression% = %valueOfMatch%]<br>
	 * 2.valueOfMatchnull̏ꍇ<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;%xpath%[%xpathOfTestExpression%]<br>
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSimpleNodeList
	 *					w\ȎɌ肳
	 * @param	xpathOfTestExpression	xpathp[^Ŏw肳ꂽXPatȟʂ
	 *									m[heXgsׂXPathw肷BXPathɂ
	 *									XPathUtil#selectSimpleSingleNodeŎw\ȎɌ肳
	 * @param	valueOfMatch	xpathOfTestExpressionp[^Ŏw肳ꂽm[h̒lƃeXg
	 *							lw肷Bnullw肵ꍇxpathp[^Ŏw肳ꂽ
	 *							m[hxpathOfTestExpressionp[^Ŏw肳ꂽm[h
	 *							SẴm[hԋpB
	 * @return	łm[hCachedNodeԋpBłȂꍇnullԋp
	 */
	public CachedNode selectSingleNodeWithNodeTest(String xpath, String xpathOfTestExpression, String valueOfMatch) {

		CachedNode[] cachedNodes = selectSimpleNodeList(xpath, true);

		if (cachedNodes == null) {
			return null;
		}

		for (int i = 0; i < cachedNodes.length; i++) {
			CachedNode[] testResultNodes = cachedNodes[i].selectSimpleNodeList(xpathOfTestExpression, true);

			if ((testResultNodes != null) && (testResultNodes.length > 0)) {
				if (valueOfMatch == null) {
					return cachedNodes[i];
				}
				else {
					for (int j = 0; j < testResultNodes.length; j++) {
						String testValue = testResultNodes[j].getNodeValue();

						if (testValue != null) {
							if (testValue.equals(valueOfMatch)) {
								return cachedNodes[i];
							}
						}
					}
				}
			}
		}

		return null;
	}

	/**
	 * ȉXPathƓʂ̌sASẴm[hԋp<br>
	 *
	 * 1.valueOfMatchnullłȂꍇ<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;%xpath%[%xpathOfTestExpression% = %valueOfMatch%]<br>
	 * 2.valueOfMatchnull̏ꍇ<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;%xpath%[%xpathOfTestExpression%]<br>
	 *
	 * @param	xpath	sXPathw肷BXPathɂXPathUtil#selectSimpleNodeList
	 *					w\ȎɌ肳
	 * @param	xpathOfTestExpression	xpathp[^Ŏw肳ꂽXPatȟʂ
	 *									m[heXgsׂXPathw肷BXPathɂ
	 *									XPathUtil#selectSimpleNodeListŎw\ȎɌ肳
	 * @param	valueOfMatch	xpathOfTestExpressionp[^Ŏw肳ꂽm[h̒lƃeXg
	 *							lw肷Bnullw肵ꍇxpathp[^Ŏw肳ꂽ
	 *							m[hxpathOfTestExpressionp[^Ŏw肳ꂽm[h
	 *							SẴm[hԋpB
	 * @return	łSẴm[hCachedNode[]ԋpBxpatȟɎgp
	 *			CachedNoe#selectSimpleNodeListnullԋpꍇnullԋpBȊO
	 *			ʂȂꍇlength0CachedNode[]ԋpB
	 */
	public CachedNode[] selectNodeListWithNodeTest(String xpath, String xpathOfTestExpression, String valueOfMatch) {

		CachedNode[] cachedNodes = selectSimpleNodeList(xpath, true);

		if (cachedNodes == null) {
			return null;
		}

		ArrayList result = new ArrayList();

		for (int i = 0; i < cachedNodes.length; i++) {
			CachedNode[] testResultNodes = cachedNodes[i].selectSimpleNodeList(xpathOfTestExpression, true);

			if (testResultNodes != null) {
				if (valueOfMatch == null) {
					result.add(cachedNodes[i]);
				}
				else {
					for (int j = 0; j < testResultNodes.length; j++) {
						String testValue = testResultNodes[j].getNodeValue();

						if (testValue != null) {
							if (testValue.equals(valueOfMatch)) {
								result.add(cachedNodes[i]);
								break;
							}
						}
					}
				}
			}
		}

		return (CachedNode[])result.toArray(_toSingleArray);
	}
}
