//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	GlobalObjective
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.math.BigDecimal;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.lo.scorm.util.XPathUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
*  Global Objective NX<BR>
*  ActivityԂŋLObjective\NX<BR>
*/
public class GlobalObjective extends Objective {
	/**
	 * ftHgRXgN^
	 */
	public GlobalObjective() {}

	/**
	 * RXgN^<BR>
	 *
	 * @param	objectiveID GlobalObjectiveID<BR>
	 */
	public GlobalObjective(String objectiveID) {
		super();

		this.objectiveID = objectiveID;
	}

	/**
	 * f擾
	 * @param	doc Document<BR>
	 * @param	parent eGg<BR>
	 * @param	traceLog fEg[X񏈗U蕪tO<BR>
	 */
	public void save(Document doc, Element parent, boolean traceLog) throws SystemException {
		XMLUtil.insertAttribute(
			doc,
			XMLUtil.append(
				doc,
				parent,
				"objective",
				new Element[] {
					XMLUtil.createElement(doc, "objectiveprogressstatus", Boolean.toString(objectiveProgressStatus)),
					XMLUtil.createElement(
						doc,
						"objectivesatisfiedstatus",
						(!objectiveProgressStatus) ? null : Boolean.toString(objectiveSatisfiedStatus)),
					XMLUtil.createElement(doc, "objectivemeasurestatus", Boolean.toString(objectiveMeasureStatus)),
					XMLUtil.createElement(
						doc,
						"objectivenormalizedmeasure",
						((!objectiveMeasureStatus) || (objectiveNormalizedMeasure == null))
							? null
							: objectiveNormalizedMeasure.toString()),
					}),
			"id",
			objectiveID);
	}

	/**
	 * f𕜋A
	 * @param parent ZbgObjectivȅm[h
	 */
	public void initializeObjectiveInformation(CachedNode parent) throws SystemException {
		initializeObjective();

		if (parent == null) {
			return;
		}

		try {
			Node objectiveNode = parent.selectSingleNodeWithNodeTest("objective", "@id", objectiveID).getNode();

			objectiveProgressStatus =
				Boolean
					.valueOf(
						XPathUtil
							.selectSimpleSingleNode(objectiveNode, "objectiveprogressstatus/text()")
							.getNodeValue())
					.booleanValue();

			if (objectiveProgressStatus) {
				objectiveSatisfiedStatus =
					Boolean
						.valueOf(
							XPathUtil
								.selectSimpleSingleNode(objectiveNode, "objectivesatisfiedstatus/text()")
								.getNodeValue())
						.booleanValue();
			}

			objectiveMeasureStatus =
				Boolean
					.valueOf(
						XPathUtil
							.selectSimpleSingleNode(objectiveNode, "objectivemeasurestatus/text()")
							.getNodeValue())
					.booleanValue();

			if (objectiveMeasureStatus) {
				Node node = XPathUtil.selectSimpleSingleNode(objectiveNode, "objectivenormalizedmeasure/text()");

				if (node != null) {
					String nodeValue = node.getNodeValue();

					if ((nodeValue != null) && (nodeValue.length() > 0)) {
						objectiveNormalizedMeasure = new BigDecimal(nodeValue);
					}
				}
			}
		}
		catch (Exception ex) {
			throw new SystemException(
				"global objective ̒f̃ZbgɎs܂B( initializeObjectiveInformation failed ) ",
				ex);
		}
	}
}
