/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//
//	t@CRg[NX
//			ύX
//				2004.01.08	VK쐬	ܖؓc ׎j
//
package jp.co.ntt.lms.xmo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FilenameFilter;
import java.io.IOException;


/**
 * t@CɊւĈȉ̑sNXłB<BR>
 * <PRE>
 *    1.1. Rs[@@w肵t@CRs[܂
 *    1.2. Ayh@w肵t@C̓eǉt@Cɒǉ܂
 *    1.3. Xg@@w肵tH_ȉ̃t@CуtH_̈ꗗ擾܂B
 * </PRE>
 * @author Nijou
 * @version 0.0.0.1 2004.01.08
 */
public class FileControl {

	/**
	 * t@Cꗗ擾ŁAt@CуfBNg̈ꗗ쐬w肵܂B
	 */
	public static final int ALL_LIST = 0;

	/**
	 * t@Cꗗ擾ŁAt@Ĉ݂̈ꗗ쐬w肵܂B
	 */
	public static final int FILE_LIST = 1;

	/**
	 * t@Cꗗ擾ŁAfBNĝ݂̈ꗗ쐬w肵܂B
	 */
	public static final int DIR_LIST = 2;

	// obt@TCY̒`
	static final int	BUFFER_SIZE = 1024 * 16;

	/**
	 * t@C̃Rs[s܂B
	 * @param strFileFrom Rs[t@CpXit@CK܂߂ĂBj
	 * @param strFileTo Rs[t@CpX<BR>
	 *            t@C܂܂ĂȂꍇ̓Rs[̃t@CƓ̃t@C
	 *            쐬āARs[܂B
	 * @return int t@CRs[̌ʂԂ܂B
	 * @exception IOException t@C̃Rs[Ɏsꍇ
	 */
	public static int copy( String strFileFrom, String strFileTo )
		throws IOException
	{
		// Rs[\bh@append敪falseɐݒ
		copy( strFileFrom, strFileTo, false );

		// Ăяoɖ߂
		return 0;
	}

	/**
	 * w肵t@C̓eǉt@Cɒǉ܂B<BR>
	 * ǉt@C݂Ȃꍇ̓Rs[s܂B
	 * @param strFileFrom ǉt@CpXit@CK܂߂ĂBj
	 * @param strFileTo ǉt@CpX<BR>
	 *            t@C܂܂ĂȂꍇ͒ǉ̃t@CƓ̃t@C
	 *            ǉ܂B
	 * @return int t@Cǉ̌ʂԂ܂
	 * @exception IOException t@CǉɎsꍇ
	 */
	public static int append( String strFileFrom, String strFileTo )
		throws IOException
	{
		// Rs[\bhappend敪trueɐݒ
		copy( strFileFrom, strFileTo, true );

		return 0;
	}

	private static int copy( String strFileFrom, String strFileTo, boolean isAppend )
		throws IOException
	{

		InputStream objFromStream = null;	// ̓t@CXg[EIuWFNg
		OutputStream objToStream = null;	// o̓t@CXg[EIuWFNg
		int rcount; 						// ۂɓǂݍ߂f[^̑傫ێ
		// obt@
		byte[] buffer = new byte[BUFFER_SIZE];

		try {
			// ʌ̃t@CJ
			objFromStream = new FileInputStream(strFileFrom);
			// ʐtH_쐬
			File objToFile = new File( strFileTo );
			File objParentDir = objToFile.getParentFile();
			objParentDir.mkdirs();
			// ʐ̃t@CJ
			objToStream = new FileOutputStream(strFileTo, isAppend);
			// ʂsȂ
			while ((rcount = objFromStream.read(buffer)) >= 0){
				objToStream.write(buffer, 0, rcount);
			}
		} catch (IOException e){		// o͗O(G[)̕ߑ
			if (objFromStream != null)
				objFromStream.close();
			if (objToStream != null)
				objToStream.close();
			throw e;		// ďoɓo͗Oʒm
		}

		// ʌ̃t@C
		objFromStream.close();
		// ʐ̃t@C
		objToStream.close();

		return 0;
	}

	/**
	 * t@Cуt@C̍폜s܂
	 * @param strPath t@CуfBNg̃pX
	 * @return int 폜
	 */
	public static int delete( String strPath )
		throws IOException
	{
		File objFile = new File( strPath );

		// t@CIuWFNgfBNg̏ꍇ
		// ̔z̃t@CуfBNgKv
		if( objFile.isDirectory() ) {
			String[] strList = objFile.list();
			for( int i = 0; i < strList.length; i++ ) {
				String strChildPath = strPath + "/" + strList[i];
				// fBNgzɑ݂炻
				delete( strChildPath );
			}
		}

		objFile.delete();

		return 0;
	}


	/**
	 * fBNg̃Rs[s܂
	 * @param strDirFrom Rs[fBNgpX
	 * @param strDirTo Rs[fBNgpX
	 * @return int fBNgRs[
	 * @exception IOException fBNg̃Rs[Ɏsꍇ
	 */
	public static int copyDir( String strDirFrom, String strDirTo )
	throws IOException
	{
	
		String[] strFileList = getFileList(strDirFrom, ALL_LIST);
		String strTempDir = strDirTo +  strDirFrom.substring(strDirFrom.lastIndexOf("/"));

		for( int i = 0; i < strFileList.length; i++ ) {

			String strFilePathFrom = strDirFrom + "/" + strFileList[i];
			String strFilePathTo = strTempDir + "/" + strFileList[i];

			File objFile = new File( strFilePathFrom );
			if( objFile.isDirectory() ) {
				copyDir( strFilePathFrom ,strTempDir );
			}
			else {
				copy(strFilePathFrom ,strFilePathTo ,false);
			}
		}
		if (strFileList.length == 0) {
			File objDir = new File( strTempDir );
			objDir.mkdirs();
		}

		return 0;
	}


	/**
	 * w肵fBNg̃t@CуfBNg̈ꗗ쐬܂B
	 * @param strDir fBNgpXw肵ĂB
	 * @return File[] 擾t@C̈ꗗłB
	 * @exception IOException ꗗ̎擾Ɏsꍇ
	 */
	public static String[] getFileList( String strDir )
		throws IOException
	{
		String[] strFileList = null;
		try {
			strFileList = getFileList( strDir, ALL_LIST );
		}
		catch( IOException e ) {
			throw e;
		}
		return strFileList;
	}

	/**
	 * w肵fBNg̃t@Ĉ݂̈ꗗ܂́AfBNĝ݂̈ꗗ擾܂B
	 * @param strDir fBNgpXw肵ĂB
	 * @param intPattern
	 * <PRE>
	 *                   ALL_LIST: t@CуfBNg̈ꗗ쐬܂B
	 *                   FILE_LIST: t@Ĉ݂̈ꗗ쐬܂B
	 *                   DIR_LIST: fBNĝ݂̈ꗗ쐬܂B
	 * </PRE>
	 * @return String[] 擾t@C̈ꗗłB
	 * @exception IOException ꗗ̎擾Ɏsꍇ
	 */
	public static String[] getFileList( String strDir, int intPattern )
		throws IOException
	{
		File objFile = new File( strDir );
		FilenameFilter objListFilter = new ListFileFilter( intPattern );
		String[] strList = objFile.list( objListFilter );
		// ꗗ擾łȂƂ͒O̔zԂ܂B
		if( strList == null ) {
			strList = new String[0];
		}
		return strList;
	}

	/**
	 * w肵t@CAtH_̂ύX܂B
	 * @param strDirBefore ύXOt@CpXw肵ĂB
	 * @param strDirAfter ύXt@CpXw肵ĂB
	 * @return int ύXʌ
	 */
	public static int renameDir( String strDirBefore, String strDirAfter )
		throws IOException
	{
		// t@C̕ύX
		File objOldPath = new File( strDirBefore );
		File objNewPath = new File( strDirAfter );
		objOldPath.renameTo(objNewPath);
		
		return 0;
	}


	/**
	 * NX<BR>
	 * t@Cꗗ擾ŁAt@Ĉ݁AfBNĝ݁Ȁꍇ̃tB^łB
	 */
	private static class ListFileFilter implements FilenameFilter {

		private int intPattern = FILE_LIST;

		/**
		 * Ȃ̃RXgN^A
		 * ftHgŁAt@Ĉ݂w肵܂B
		 */
		public ListFileFilter() {
			intPattern = FILE_LIST;
		}

		/**
		 * ꗗ擾p^[w肷ARXgN^łB
		 * @param intPattern ALL_LIST: t@CуfBNg̈ꗗ쐬܂B<BR>
		 *                   FILE_LIST: t@Ĉ݂̈ꗗ쐬܂<BR>
		 *                   DIR_LIST: fBNĝ݂̈ꗗ쐬܂<BR>
		 */
		public ListFileFilter( int Pattern ) {
			this.intPattern = Pattern;
		}

		/**
		 * FilenameFilterC^tF[Xaccept\bh̎łB
		 * RXgN^Ŏw肳ꂽp^[ɕԂl肵܂
		 */
		public boolean accept( File dir, String name ) {
			String strFileName = null;
			File objFile = null;
			boolean blReturn = false;
			if( dir != null ) {
				strFileName = dir.toString() + "/" + name;
				objFile = new File( strFileName );
				switch( intPattern ) {
					case ALL_LIST:
						// ׂtrue
						blReturn = true;
						break;
					case FILE_LIST:
						// 쐬t@Ct@Ĉtrue
						if( objFile.isFile() ) {
							blReturn = true;
						}
						break;
					case DIR_LIST:
						// 쐬t@CfBNĝtrue
						if( objFile.isDirectory() ) {
							blReturn = true;
						}
						break;
				}
			}

			return blReturn;
		}

	}
}
