//
// CopyRight (C) 2002, IPA, eLC, NTT Resonant Inc. All rights reserved.
//
//	Status
//
//	ύX
//		2002.12.25  VK쐬
//

package jp.co.ntt.lms.lo.scorm.kernel;

import java.util.Calendar;
import java.util.Vector;

import jp.co.ntt.lms.lo.scorm.kernel.exception.SystemException;
import jp.co.ntt.lms.lo.scorm.util.CachedNode;
import jp.co.ntt.lms.lo.scorm.util.DateUtility;
import jp.co.ntt.lms.lo.scorm.util.XMLUtil;
import jp.co.ntt.lms.lo.scorm.util.XPathUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Status class<BR>
 * ActivityƂ̃Xe[^X\NX<BR>
 */
public class Status {
	/** activity is active ̃tO */
	private boolean activityisActive;

	/** activity is suspended */
	private boolean activityisSuspended;

	/** available children */
	private Activity[] availableChildren;

	/** attempt suspended time - Calendar */
	private Vector attemptSuspendedTime;

	/** attempt start time - Calendar */
	private Vector attemptStartTime;

	/** activity start time */
	private Calendar activityStartTime;

	/** selection status */
	private boolean selectionStatus;

	/** randomize status */
	private boolean randomizeStatus;

	/** this Activity */
	private Activity activity;

	/**
	 * ftHgRXgN^
	 */
	public Status() {
	}

	/**
	 * RXgN^<BR>
	 *
	 * @param activity statusANeBreB<BR>
	 * @param manifestNode ލ\m[h<BR>
	 */
	public Status(Activity activity, CachedNode manifestNode) {
		//ANeBreBݒ
		this.activity = activity;
	}

	/**
	 * f擾<BR>
	 *
	 * @return status̒f̕<BR>
	 */
	public void save(Document doc, Element parent, boolean traceLog) throws SystemException {
		try {
			Element statusNode = XMLUtil.append(doc, parent, "status");

			XMLUtil.append(doc, statusNode, XMLUtil.createElement(doc, "activityisactive", Boolean.toString(activityisActive)));

			XMLUtil.append(doc, statusNode, XMLUtil.createElement(doc, "activityissuspended", Boolean.toString(activityisSuspended)));

			Element availableChildrenNode = XMLUtil.append(doc, statusNode, "availablechildren");

			if (availableChildren != null) {
				for (int i = 0; i < availableChildren.length; i++) {
					XMLUtil.append(doc, availableChildrenNode, "id", availableChildren[i].getIdentifier());
				}
			}

			Element activityStartTimeNode = XMLUtil.append(doc, statusNode, "activitystarttime");
			XMLUtil.append(doc, activityStartTimeNode, "date", DateUtility.toString(activityStartTime));

			Element attemptSuspendedTimeNode = XMLUtil.append(doc, statusNode, "attemptsuspendedtime");

			for (int i = 0; i < attemptSuspendedTime.size(); i++) {
				XMLUtil.append(doc, attemptSuspendedTimeNode, "date", DateUtility.toString((Calendar)attemptSuspendedTime.get(i)));
			}

			Element attemptStartTimeNode = XMLUtil.append(doc, statusNode, "attemptstarttime");

			for (int i = 0; i < attemptStartTime.size(); i++) {
				XMLUtil.append(doc, attemptStartTimeNode, "date", DateUtility.toString((Calendar)attemptStartTime.get(i)));
			}

			XMLUtil.append(doc, statusNode, XMLUtil.createElement(doc, "selectionstatus", Boolean.toString(selectionStatus)));

			XMLUtil.append(doc, statusNode, XMLUtil.createElement(doc, "randomizestatus", Boolean.toString(randomizeStatus)));
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("save failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 *  status ̏<BR>
	 * 
	 */
	public void initializeStatusInformation(CachedNode parent) throws SystemException {
		activityisActive = false;
		activityisSuspended = false;
		availableChildren = activity.getChildren();
		attemptSuspendedTime = new Vector();
		attemptStartTime = new Vector();
		selectionStatus = false;
		randomizeStatus = false;

		if (parent == null) {
			return;
		}

		try {
			Node statusNode = XPathUtil.selectSingleChildNode(parent.getNode(), "status");

			int max;
			Node[] list;

			// activity is active
			activityisActive = Boolean.valueOf(XPathUtil.selectSimpleSingleNode(statusNode, "activityisactive/text()").getNodeValue()).booleanValue();

			// activity is suspended
			activityisSuspended = Boolean.valueOf(XPathUtil.selectSimpleSingleNode(statusNode, "activityissuspended/text()").getNodeValue()).booleanValue();

			// available children
			list = XPathUtil.selectSimpleNodeList(statusNode, "availablechildren/id/text()");

			if (list != null) {
				max = list.length;

				if (max > 0) {
					availableChildren = new Activity[max];
					for (int i = 0; i < max; i++) {
						availableChildren[i] = activity.getActivity(list[i].getNodeValue());
					}
				}
			}

			// activity start time
			Node node = XPathUtil.selectSimpleSingleNode(statusNode, "activitystarttime/date/text()");

			if (node != null) {
				activityStartTime = DateUtility.toCalendar(node.getNodeValue());
			}

			// attempt suspended time
			list = XPathUtil.selectSimpleNodeList(statusNode, "attemptsuspendedtime/date/text()");

			if (list != null) {
				max = list.length;

				for (int i = 0; i < max; i++) {
					attemptSuspendedTime.add(DateUtility.toCalendar(list[i].getNodeValue()));
				}
			}

			// attempt start time
			list = XPathUtil.selectSimpleNodeList(statusNode, "attemptstarttime/date/text()");

			if (list != null) {
				max = list.length;

				for (int i = 0; i < max; i++) {
					attemptStartTime.add(DateUtility.toCalendar(list[i].getNodeValue()));
				}
			}

			// selection status
			selectionStatus = Boolean.valueOf(XPathUtil.selectSimpleSingleNode(statusNode, "selectionstatus/text()").getNodeValue()).booleanValue();

			// randomize status
			randomizeStatus = Boolean.valueOf(XPathUtil.selectSimpleSingleNode(statusNode, "randomizestatus/text()").getNodeValue()).booleanValue();
		}
		catch (SystemException ex) {
			throw ex;
		}
		catch (Exception ex) {
			throw new SystemException("initializeStatusInformation failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * s̏<BR>
	 */
	public void initializeAttemptInformation() throws SystemException {
		try {
			// wKJnԂ
			attemptStartTime.clear();

			// wKfԂ
			attemptSuspendedTime.clear();
		}
		catch (Exception ex) {
			throw new SystemException("initializeAttemptInformation failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * I<BR>
	 */
	public void terminate() {
		if (availableChildren != null) {
			for (int i = 0; i < availableChildren.length; i++) {
				availableChildren[i] = null;
			}
		}

		activity = null;
	}

	/**
	 * activity is active ̃vpeBւ̃Zbg<BR>
	 *
	 * @param	status	true:activity is active  true ɂ<BR>
	 *						( ̃ANeBreB͌݊wKA͊wK̃ANeBreB̑cłB)<BR>
	 *					false:activity is active  false ɂ<BR>
	 *						( ̃ANeBreB͌݁AwKA͊wKς݂łB)<BR>
	 */
	public void setActivityIsActive(boolean status) {
		activityisActive = status;
	}

	/**
	 *	activity is active ̃vpeB̎擾<BR>
	 *
	 *	@return	activity is active ԋp
	 */
	public boolean getActivityIsActive() {
		return activityisActive;
	}

	/**
	 *	activity is suspended ̃vpeBւ̃Zbg<BR>
	 *
	 *	@param	 status	 true:activity is suspended  true ɂ<BR>
	 *							( ̃ANeBreB͌݁AwK𒆒fĂA
	 *								͒fANeBreB̑cłB)<BR>
	 *					  false:activity is suspended  false ɂ<BR>
	 *							( ̃ANeBreB͌݁AwK𒆒fĂȂB)<BR>
	 */
	public void setActivityIsSuspended(boolean status) {
		activityisSuspended = status;
	}

	/**
	 *	activity is suspended ̃vpeB̎擾<BR>
	 *
	 *	@return	activity is suspended ԋp
	 */
	public boolean getActivityIsSuspended() {
		return activityisSuspended;
	}

	/**
	 * qANeBreB̂Aselection process  randomize process ɂA<BR>
	 * wK\ƔfꂽANeBreB available children ƂāAZbgB<BR>
	 *
	 * @param	availableChildren wK\ƔfꂽqANeBreB̔z<BR>
	 */
	public void setAvailableChildren(Activity[] availableChildren) {
		this.availableChildren = availableChildren;
	}

	/**
	 * available children 擾<BR>
	 *
	 * @return  wK\ƔfꂽqANeBreB̔z<BR>
	 */
	public Activity[] getAvailableChildren() {
		return availableChildren;
	}

	/**
	 * fԂo^<BR>
	 *
	 * @param  suspend f̓<BR>
	 */
	public void setAttemptSuspendedTime(Calendar suspend) {
		attemptSuspendedTime.add(suspend);
	}

	/**
	 * wKJnԂZbg<BR>
	 *
	 * @param	start Jn<BR>
	 */
	public void setAttemptStartTime(Calendar start) {
		if (activityStartTime == null) {
			activityStartTime = start;
		}
		attemptStartTime.add(start);
	}

	/**
	 * wKԂ̎擾<BR>
	 *
	 * @param	current ݂̎( wKI̓ )<BR>
	 * @return  wK<BR> 
	 */
	public Duration getActivityAbsoluteDuration(Calendar current) throws SystemException {

		if (activityStartTime == null) {
			return new Duration(0);
		}
		//ANeBreBoߎԂ擾
		return new Duration(current.getTimeInMillis() - activityStartTime.getTimeInMillis());
	}

	/**
	 * AttemptwKԂ̎擾<BR>
	 *
	 * @param	current ݂̎( wKI̓ )<BR>
	 * @return  wK<BR> 
	 */
	public Duration getAtemptAbsoluteDuration(Calendar current) throws SystemException {

		if (attemptStartTime.size() <= 0) {
			return new Duration(0);
		}
		//݂̎šoߎԂ擾
		return new Duration(current.getTimeInMillis() - ((Calendar)attemptStartTime.get(0)).getTimeInMillis());
	}

	/**
	 * s̎wKԂ̎擾<BR>
	 *
	 * @param	current ݂̓( wKI̓ ) <BR>
	 * @return	wK<BR>
	 */
	public Duration getAttemptExperiencedDuration(Calendar current) throws SystemException {
		try {
			// X^[g^C݂Ȃꍇ0ԋp
			if (attemptStartTime.size() <= 0) {
				return new Duration(0);
			}

			long duration = 0;
			long attemptStartTimePoint = 0;

			// X^[g^CŃ[v
			for (int i = 0; i < attemptStartTime.size(); i++) {
				attemptStartTimePoint = ((Calendar)attemptStartTime.get(i)).getTimeInMillis();
				// fԂ݂ꍇ
				if (i < attemptSuspendedTime.size()) {
					for (int j = 0; j < attemptSuspendedTime.size(); j++) {
						// X^[g^C傫
						if (((Calendar)attemptSuspendedTime.get(j)).getTimeInMillis() > attemptStartTimePoint) {
							// Ō̃X^[g^C܂͎̃X^[g^C菬
							if (i == attemptStartTime.size() - 1
								|| (i < attemptStartTime.size() - 1 && ((Calendar)attemptSuspendedTime.get(j)).getTimeInMillis() <= ((Calendar)attemptStartTime.get(i + 1)).getTimeInMillis())) {
								duration += (((Calendar)attemptSuspendedTime.get(j)).getTimeInMillis() - attemptStartTimePoint);
								break;
							}
						}
					}
				}
			}

			return new Duration(duration);
		}
		catch (Exception ex) {
			throw new SystemException("getAttemptExperiencedDuration failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * ŐVwKԂ̎擾<BR>
	 *
	 * @param	current ݂̓( wKI̓ ) <BR>
	 * @return	wK<BR>
	 */
	public Duration getLastExperiencedDuration(Calendar current) throws SystemException {
		try {
			// X^[g^C݂Ȃꍇ0ԋp
			if (attemptStartTime.size() <= 0) {
				return new Duration(0);
			}

			long duration = 0;
			long attemptStartTimePoint = 0;

			// Ō̃X^[g^CX^[g^C
			attemptStartTimePoint = ((Calendar)attemptStartTime.get(attemptStartTime.size() - 1)).getTimeInMillis();

			// fԂ݂ꍇ
			if (0 < attemptSuspendedTime.size()) {
				for (int j = 0; j < attemptSuspendedTime.size(); j++) {
					// X^[g^C傫
					if (((Calendar)attemptSuspendedTime.get(j)).getTimeInMillis() > attemptStartTimePoint) {
						// fԂŌ̒fԂł邩
						if (j == attemptSuspendedTime.size() - 1) {
							duration = (((Calendar)attemptSuspendedTime.get(j)).getTimeInMillis() - attemptStartTimePoint);
						}
						break;
					}
				}
			}

			return new Duration(duration);
		}
		catch (Exception ex) {
			throw new SystemException("getLastExperiencedDuration failed [ActivityID:" + activity.getIdentifier() + "]", ex);
		}
	}

	/**
	 * selectionԂݒ肷
	 *
	 * @param status ݒ肷Ԃw肷
	 */
	public void setSelectionStatus(boolean status) {
		selectionStatus = status;
	}

	/**
	 * selectionԂ擾
	 *
	 * @return selection
	 */
	public boolean getSelectionStatus() {
		return selectionStatus;
	}

	/**
	 * randomizeԂݒ肷
	 *
	 * @param status ݒ肷Ԃw肷
	 */
	public void setRandomizeStatus(boolean status) {
		randomizeStatus = status;
	}

	/**
	 * randomizeԂ擾
	 *
	 * @return randomize
	 */
	public boolean getRandomizeStatus() {
		return randomizeStatus;
	}
}
