// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef MAIN_LOOP_HPP
#define MAIN_LOOP_HPP

class sequence_manager;
class input_handler;
#include "system_base/framerate_manager.hpp"
class sequence;

class main_loop
{
public:
	main_loop( sequence_manager* sm, input_handler* ih );
	virtual ~main_loop();

	void enter_main_loop();

private:
	sequence_manager* sm;
	input_handler* ih;
	framerate_manager fm;

	void draw_frame( sequence* current_sequence );
	void draw_extra();

	main_loop( const main_loop& );
	main_loop& operator=( const main_loop& );

	main_loop( main_loop&& );
	main_loop& operator=( main_loop&& );
};

#endif // MAIN_LOOP_HPP
