// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_top/main_loop.hpp"
#include "system_base/sequence_manager.hpp"
#include "system_base/input_handler.hpp"
#include "system_base/framerate_manager.hpp"
#include "system_base/sequence.hpp"
#include "system_base/controller.hpp"
#include "DxLib.h"

main_loop::main_loop( sequence_manager* sm, input_handler* ih )
	: sm( sm ),
	  ih( ih ),
	  fm( 60 )
{
}

main_loop::~main_loop()
{
}

void main_loop::enter_main_loop()
{
	// ݂̃V[PXւ̃|C^
	sequence* current_sequence = nullptr;
	controller* current_controller = nullptr;

	// C[v
	while ( true )
	{
		// ݂̃V[PX擾
		current_sequence = this->sm->get_sequence();
		current_controller = this->sm->get_controller();

		// [U̓͂
		// pL[ꂽAC[v甲
		if ( this->ih->poll_input() == false )
		{
			break;
		}

		// [U͂
		current_controller->handle_input( this->ih );

		// V[PXXV
		current_sequence->update();

		// t[`悷
		this->draw_frame( current_sequence );

		// t[[g𒲐߂
		this->fm.adjust_framerate();
	}
}

void main_loop::draw_frame( sequence* current_sequence )
{
	// ܂At[
	DxLib::ClearDrawScreen();

	// Vt[`悷
	current_sequence->draw();

	// t[[g󎚂
	this->fm.print_framerate();

	// `̎
	this->draw_extra();

	// \̃obt@tbv
	DxLib::ScreenFlip();
}

void main_loop::draw_extra()
{
}
