// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef WIN32_DRIVER_HPP
#define WIN32_DRIVER_HPP

#if defined(_WIN32)

#include <cstdio>
#include <fstream>
#include <streambuf>

class win32_driver
{
public:
	static win32_driver* instance();

	// IɏI
	void dispose();

private:
	// Wo͂Ɋ֘AÂt@C\
	FILE* stdout_file;

	// WG[o͂Ɋ֘AÂt@C\
	FILE* stderr_file;

	// std::cout ɋl߂R\[obt@
	std::filebuf cout_filebuf;

	// std::cout ĂɗȂobt@
	std::streambuf* save_coutbuf;

	// std::cerr ɋl߂R\[obt@
	std::filebuf cerr_filebuf;

	// std::cerr ĂɗȂobt@
	std::streambuf* save_cerrbuf;

	// R\[o͂邽߂ɏ
	void console_open();

	// R\[o͂n
	void console_close();

	win32_driver();
	virtual ~win32_driver();

	win32_driver( const win32_driver& );
	win32_driver& operator=( const win32_driver& );

	win32_driver( win32_driver&& );
	win32_driver& operator=( win32_driver&& );
};

#endif // _WIN32

#endif // WIN32_DRIVER_HPP
