// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_base/win32_driver.hpp"

#if defined(_WIN32)

#include <windows.h>
#include <cstdio>
#include <iostream>

win32_driver* win32_driver::instance()
{
	static win32_driver _instance;
	return &_instance;
}

void win32_driver::dispose()
{
	this->console_close();
}

void win32_driver::console_open()
{
	// R\[o͂邽߂̏
	::AllocConsole();

	// stdout
	::freopen_s( &( this->stdout_file ), "CONOUT$", "w", stdout );

	// stderr
	::freopen_s( &( this->stderr_file ), "CONOUT$", "w", stderr );

	// cout
	this->cout_filebuf.open( "CONOUT$", std::ios_base::out );
	if ( this->cout_filebuf.is_open() )
		this->save_coutbuf = std::cout.rdbuf( &( this->cout_filebuf ) );

	// cerr
	this->cerr_filebuf.open( "CONOUT$", std::ios_base::out );
	if ( this->cerr_filebuf.is_open() )
		this->save_cerrbuf = std::cerr.rdbuf( &( this->cerr_filebuf ) );
}

void win32_driver::console_close()
{
	// cerr
	if ( this->save_cerrbuf != nullptr )
		std::cerr.rdbuf( this->save_cerrbuf );
	this->cerr_filebuf.close();

	// cout
	if ( this->save_coutbuf != nullptr )
		std::cout.rdbuf( this->save_coutbuf );
	this->cout_filebuf.close();

	// stderr
	std::fclose( this->stderr_file );

	// stdout
	std::fclose( this->stdout_file );

	// R\[o͂n
	::FreeConsole();
}

win32_driver::win32_driver()
	: stdout_file( NULL ),
	  stderr_file( NULL ),
	  cout_filebuf(),
	  save_coutbuf( nullptr ),
	  cerr_filebuf(),
	  save_cerrbuf( nullptr )
{
	this->console_open();
}

win32_driver::~win32_driver()
{
}

#endif // _WIN32
