// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "graphics/sprite.hpp"
#include "common/util.hpp"
#include "DxLib.h"
#include "graphics/image.hpp"

sprite::sprite()
	: handle ( nullptr ),
	  n_chips( -1 ),
	  x_chips( -1 ),
	  y_chips( -1 ),
	  chip_w ( -1 ),
	  chip_h ( -1 )
{
}

sprite::sprite( int* handle, int n_chips, int x_chips, int y_chips, int chip_w, int chip_h )
	: handle ( handle  ),
	  n_chips( n_chips ),
	  x_chips( x_chips ),
	  y_chips( y_chips ),
	  chip_w ( chip_w  ),
	  chip_h ( chip_h  )
{
}

sprite::~sprite()
{
}

void sprite::init( int* handle, int n_chips, int x_chips, int y_chips, int chip_w, int chip_h )
{
	this->handle  = handle ;
	this->n_chips = n_chips;
	this->x_chips = x_chips;
	this->y_chips = y_chips;
	this->chip_w  = chip_w ;
	this->chip_h  = chip_h ;
}

void sprite::draw( int index, point p, bool trans_flag )
{
	DxLib::DrawGraph( p.x, p.y, this->handle[ index ], trans_flag ? TRUE : FALSE );
}

void sprite::draw( int x_chip, int y_chip, point p, bool trans_flag )
{
	int index = this->x_chips * y_chip + x_chip;
	DxLib::DrawGraph( p.x, p.y, this->handle[ index ], trans_flag ? TRUE : FALSE );
}

void sprite::recycle_image( image* i, int index )
{
	*i = image( this->handle[ index ], this->chip_w, this->chip_h );
}

void sprite::recycle_image( image* i, int x_chip, int y_chip )
{
	int index = this->x_chips * y_chip + x_chip;
	*i = image( this->handle[ index ], this->chip_w, this->chip_h );
}

image sprite::get_image( int index )
{
	return image( this->handle[ index ], this->chip_w, this->chip_h );
}

image sprite::get_image( int x_chip, int y_chip )
{
	int index = this->x_chips * y_chip + x_chip;
	return image( this->handle[ index ], this->chip_w, this->chip_h );
}
