// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "graphics/image.hpp"
#include "DxLib.h"
#include "common/util.hpp"

image::image()
	: handle( -1 ),
	  width ( -1 ),
	  height( -1 ),
	  managed( false )
{
}

image::image( int handle, int width, int height )
	: handle( handle ),
	  width ( width  ),
	  height( height ),
	  managed( false )
{
}

image::~image()
{
	if ( this->managed == true )
	{
		DxLib::DeleteGraph( this->handle );
	}
}

void image::init( int handle, int width, int height )
{
	this->handle  = handle;
	this->width   = width ;
	this->height  = height;
	this->managed = false ;
}

void image::draw( int x, int y, bool trans_flag )
{
	DxLib::DrawGraph(   x,   y, this->handle, trans_flag ? TRUE : FALSE );
}

void image::draw( point p, bool trans_flag )
{
	DxLib::DrawGraph( p.x, p.y, this->handle, trans_flag ? TRUE : FALSE );
}

void image::draw( bool trans_flag )
{
	DxLib::DrawGraph(   0,   0, this->handle, trans_flag ? TRUE : FALSE );
}
