// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/party_btl.hpp"
#include <cstddef>
class battle_joiner;
#include <cassert>

party_btl::party_btl()
	: current_size( 0U ),
	  initial_size( 0U )
{
	for ( std::size_t i = 0 ; i < this->capacity ; ++i )
	{
		this->current_members[ i ] = nullptr;
		this->initial_members[ i ] = nullptr;
	}
}

party_btl::party_btl( battle_joiner* members[], std::size_t size )
	: current_size( 0U ),
	  initial_size( 0U )
{
	this->init( members, size );
}

party_btl::~party_btl()
{
}

void party_btl::init( battle_joiner* members[], std::size_t size )
{
	assert( size <= this->capacity );

	this->current_size = size;
	this->initial_size = size;

	for ( std::size_t i = 0 ; i < this->capacity ; ++i )
	{
		this->current_members[ i ] = nullptr;
		this->initial_members[ i ] = nullptr;
	}

	for ( std::size_t i = 0 ; i < size ; ++i )
	{
		this->current_members[ i ] = members[ i ];
		this->initial_members[ i ] = members[ i ];
	}
}

int party_btl::get_ordering( battle_joiner* member )
{
	for ( std::size_t i = 0 ; i < this->current_size ; ++i )
	{
		if ( this->current_members[ i ] == member )
		{
			return i;
		}
	}

	return -1;
}

battle_joiner* party_btl::get_member( std::size_t ordering )
{
	if ( ordering < this->current_size )
	{
		return this->current_members[ ordering ];
	}
	else
	{
		return nullptr;
	}
}
