// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef LAYERED_DRAWER_BTL_HPP
#define LAYERED_DRAWER_BTL_HPP

class drawable;

class layered_drawer_btl
{
public:
	enum layer_t
	{
		bottommost,
		background,
		bottom,
		enemy,
		enemy_effect,
		middle,
		hero,
		hero_effect,
		top,
		window_5,
		window_4,
		window_3,
		window_2,
		window_1,
		topmost,
		sizeof_layer_t,
		invalid_layer = -1,
	};

	layered_drawer_btl();
	virtual ~layered_drawer_btl();

	void clear();

	void draw();

	void add_to_layer     ( layer_t l, drawable* d );
	void remove_from_layer( layer_t l, drawable* d );

	bool is_layer_enabled ( layer_t l ) { return this->layer_enabled[ l ]; }
	void set_layer_enabled( layer_t l, bool layer_enabled ) { this->layer_enabled[ l ] = layer_enabled; }

private:
	enum { capacity = 10 };

	drawable* bottommost_  [ capacity ];
	drawable* background_  [ capacity ];
	drawable* bottom_      [ capacity ];

	drawable* enemy_       [ capacity ];
	drawable* enemy_effect_[ capacity ];
	drawable* middle_      [ capacity ];
	drawable* hero_        [ capacity ];
	drawable* hero_effect_ [ capacity ];

	drawable* top_         [ capacity ];
	drawable* window_5_    [ capacity ];
	drawable* window_4_    [ capacity ];
	drawable* window_3_    [ capacity ];
	drawable* window_2_    [ capacity ];
	drawable* window_1_    [ capacity ];
	drawable* topmost_     [ capacity ];

	drawable* ( *layers[ sizeof_layer_t ] )[ capacity ];

	bool layer_enabled[ sizeof_layer_t ];
};

#endif // LAYERED_DRAWER_BTL_HPP
