// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef HERO_PARTY_WINDOW_HPP
#define HERO_PARTY_WINDOW_HPP

#include "graphics/drawable.hpp"
#include "common/util.hpp"
class hero_party_btl;
class atb_gauge;
class hero_btl;
#include "graphics/framed_window.hpp"

class hero_party_window : public drawable
{
public:
	hero_party_window( rectangle r );
	virtual ~hero_party_window();

	void init( hero_party_btl* hero_party );

	virtual void draw();

	void set_gauge( atb_gauge* gauge[] );

private:
	enum { n_hero = 4 };

	hero_party_btl* hero_party;
	hero_btl* hero[ n_hero ];

	framed_window frame;
	point frame_position;

	const char* name[ n_hero ];
	point name_position[ n_hero ];

	int current_hp[ n_hero ];
	int maximum_hp[ n_hero ];
	point hp_position[ n_hero ];

	int current_mp[ n_hero ];
	point mp_position[ n_hero ];

	atb_gauge* gauge[ n_hero ];
	point gauge_position[ n_hero ];
};

#endif // HERO_PARTY_WINDOW_HPP
