// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/hero_party_window.hpp"
#include "common/util.hpp"
#include "graphics/drawable.hpp"
#include "battle/hero_party_btl.hpp"
#include "graphics/framed_window.hpp"
#include "battle/hero_btl.hpp"
#include "DxLib.h"
#include "battle/atb_gauge.hpp"

hero_party_window::hero_party_window( rectangle r )
	: drawable(),
	  hero_party( nullptr ),
	  frame( r ),
	  frame_position( r.x, r.y )
{
	for ( int i = 0 ; i < this->n_hero ; ++i )
	{
		this->hero[ i ] = nullptr;

		this->name      [ i ] = nullptr;
		this->current_hp[ i ] = -1     ;
		this->maximum_hp[ i ] = -1     ;
		this->current_mp[ i ] = -1     ;
		this->gauge     [ i ] = nullptr;

		this->name_position [ i ] = point( -1, -1 );
		this->hp_position   [ i ] = point( -1, -1 );
		this->mp_position   [ i ] = point( -1, -1 );
		this->gauge_position[ i ] = point( -1, -1 );
	}

	this->name[ 0 ] = "fBm";
	this->name[ 1 ] = "~A";
	this->name[ 2 ] = "}A";
	this->name[ 3 ] = "WFC";

	point orig_offset (   0, 0 );
	int v_interval = 15;

	point name_offset (  15, 6 );
	point hp_offset   (   0, 0 );
	point mp_offset   (   0, 0 );
	point gauge_offset( 120, 8 );

	point t( -1, -1 );

	for ( int i = 0 ; i < this->n_hero ; ++i )
	{
		t.x = this->frame_position.x + orig_offset.x;
		t.y = this->frame_position.y + orig_offset.y + v_interval * i;

		this->name_position [ i ] = point( t.x + name_offset .x, t.y + name_offset .y );
		this->hp_position   [ i ] = point( t.x + hp_offset   .x, t.y + hp_offset   .y );
		this->mp_position   [ i ] = point( t.x + mp_offset   .x, t.y + mp_offset   .y );
		this->gauge_position[ i ] = point( t.x + gauge_offset.x, t.y + gauge_offset.y );
	}
}

hero_party_window::~hero_party_window()
{
}

void hero_party_window::init( hero_party_btl* hero_party )
{
	this->hero_party = hero_party;
}

void hero_party_window::draw()
{
	this->frame.draw();

	point t( -1, -1 );
	int color = DxLib::GetColor( 255, 255, 255 );

	for ( int i = 0 ; i < this->n_hero ; ++i )
	{
		if ( this->name[ i ] != nullptr )
		{
			t.x = this->name_position[ i ].x;
			t.y = this->name_position[ i ].y;

			DxLib::SetFontSize( 10 );
			DxLib::DrawString( t.x,  t.y, this->name[ i ], color );
			DxLib::SetFontSize( 10 );

			this->gauge[ i ]->set_position( this->gauge_position[ i ] );
			this->gauge[ i ]->draw();
		}
	}
}

void hero_party_window::set_gauge( atb_gauge* gauge[] )
{
	for ( int i = 0 ; i < this->n_hero ; ++i )
	{
		this->gauge[ i ] = gauge[ i ];
	}
}
