// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef CHARINFO_PROVIDER_HPP
#define CHARINFO_PROVIDER_HPP

class hero_btl;
#include "common/character_id.hpp"
#include "common/character_status.hpp"
class enemy_btl;
class hero_party_btl;
class battle_joiner;
#include <cstddef>
class enemy_party_btl;

class charinfo_provider
{
public:
	static charinfo_provider* instance();

	void populate_hero ( hero_btl*  hero , character_id::hero_t  hero_id , int ordering, character_status::battle_position position );
	void populate_enemy( enemy_btl* enemy, character_id::enemy_t enemy_id, int ordering, character_status::battle_position position );

	void populate_hero_party ( hero_party_btl*  hero_party , battle_joiner* members[], std::size_t size );
	void populate_enemy_party( enemy_party_btl* enemy_party, battle_joiner* members[], std::size_t size );

private:
	charinfo_provider();
	virtual ~charinfo_provider();

	charinfo_provider( const charinfo_provider& );
	charinfo_provider& operator=( const charinfo_provider& );

	charinfo_provider( charinfo_provider&& );
	charinfo_provider& operator=( charinfo_provider&& );
};

#endif // CHARINFO_PROVIDER_HPP
