// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/charinfo_provider.hpp"
#include "battle/hero_btl.hpp"
#include "common/character_id.hpp"
#include "common/character_status.hpp"
#include "common/hero_status.hpp"
#include "graphics/image_lookup.hpp"
class sprite;
#include "graphics/character_graphic.hpp"
#include "common/util.hpp"
#include "battle/character_graphic_btl.hpp"
#include "battle/atb_gauge.hpp"
#include "battle/enemy_btl.hpp"
#include "battle/hero_party_btl.hpp"
class battle_joiner;
#include <cstddef>
#include "battle/enemy_party_btl.hpp"

charinfo_provider* charinfo_provider::instance()
{
	static charinfo_provider _instance;
	return &_instance;
}

void charinfo_provider::populate_hero( hero_btl* hero, character_id::hero_t hero_id, int ordering, character_status::battle_position position )
{
	character_id* id = hero->get_id();
	id->init( hero_id );

	hero_status* status = hero->get_status();
	status->set_position( position );
	status->set_speed( 5 );
	status->init_c( ordering );

	hero_status* init_status = hero->get_init_status();
	init_status->set_position( position );
	init_status->init_c( ordering );

	image_lookup* il = image_lookup::instance();

	sprite*                      base_sprite   = il->get_sprite( image_lookup::hero_to_sprite[ hero_id ] );
	character_graphic::char_chip base_index    = character_graphic::battle_default;
	point                        base_position = character_graphic_btl::battle_position[ position ][ ordering ];

	character_graphic_btl* graphic      = hero->get_graphic();
	character_graphic*     base_graphic = graphic->get_base_graphic();
	base_graphic->init( base_sprite, base_index, base_position );

	atb_gauge* gauge = hero->get_gauge();
	gauge->init();
}

void charinfo_provider::populate_enemy( enemy_btl* enemy, character_id::enemy_t enemy_id, int ordering, character_status::battle_position position )
{
}

void charinfo_provider::populate_hero_party( hero_party_btl* hero_party, battle_joiner* members[], std::size_t size )
{
	hero_party->init( members, size );
}

void charinfo_provider::populate_enemy_party( enemy_party_btl* enemy_party, battle_joiner* members[], std::size_t size )
{
	enemy_party->init( members, size );
}

charinfo_provider::charinfo_provider()
{
}

charinfo_provider::~charinfo_provider()
{
}
