// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef SEQUENCE_MANAGER_HPP
#define SEQUENCE_MANAGER_HPP

class sequence;
class controller;

class sequence_manager
{
public:
	enum sequence_t
	{
		battle,
		//camp,
		//dungeon,
		//ending,
		//opening,
		//save_load,
		//shop,
		//title,
		//world_map,
		sizeof_sequence_t
	};

	static sequence_manager* instance( sequence* sa[], controller* ca[] );

	void switch_sequence( sequence_t next );

	sequence*   get_sequence  () { return this->s_current; }
	controller* get_controller() { return this->c_current; }

	void set_sequence  ( sequence*   s ) { this->s_current = s; }
	void set_controller( controller* c ) { this->c_current = c; }

private:
	sequence* s_current;
	sequence* sa[ sizeof_sequence_t ];

	controller* c_current;
	controller* ca[ sizeof_sequence_t ];

	sequence_manager( sequence* sa[], controller* ca[] );
	virtual ~sequence_manager();

	sequence_manager( const sequence_manager& );
	sequence_manager& operator=( const sequence_manager& );

	sequence_manager( sequence_manager&& );
	sequence_manager& operator=( sequence_manager&& );
};

#endif // SEQUENCE_MANAGER_HPP
