// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "system_base/input_handler_dxlib.hpp"
#include "system_base/input_handler.hpp"
#include <iostream>
#include "DxLib.h"

input_handler_dxlib::input_handler_dxlib()
	: input_handler()
{
}

input_handler_dxlib::~input_handler_dxlib()
{
}

bool input_handler_dxlib::poll_input()
{
	this->current_mask = this->INITIAL_MASK;

	DxLib::ProcessMessage();
	DxLib::GetHitKeyStateAll( this->key_state_buf );

	// pL[ꂽAUԂ
	if ( this->key_state_buf[ KEY_INPUT_Q ] == 1 )
	{
		std::cout << "quit" << std::endl;
		return false;
	}

	return true;
}

void input_handler_dxlib::interpret_input()
{
	this->current_mask = 0U;

	// ㉺E
	if ( this->key_state_buf[ KEY_INPUT_UP ] == 1 )
	{
		this->current_mask |= this->AXIS_UP;
	}
	if ( this->key_state_buf[ KEY_INPUT_DOWN ] == 1 )
	{
		this->current_mask |= this->AXIS_DOWN;
	}
	if ( this->key_state_buf[ KEY_INPUT_LEFT ] == 1 )
	{
		this->current_mask |= this->AXIS_LEFT;
	}
	if ( this->key_state_buf[ KEY_INPUT_RIGHT ] == 1 )
	{
		this->current_mask |= this->AXIS_RIGHT;
	}

	// `awx
	if ( this->key_state_buf[ KEY_INPUT_V ] == 1 )
	{
		this->current_mask |= this->BUTTON_A;
	}
	if ( this->key_state_buf[ KEY_INPUT_C ] == 1 )
	{
		this->current_mask |= this->BUTTON_B;
	}
	if ( this->key_state_buf[ KEY_INPUT_D ] == 1 )
	{
		this->current_mask |= this->BUTTON_X;
	}
	if ( this->key_state_buf[ KEY_INPUT_X ] == 1 )
	{
		this->current_mask |= this->BUTTON_Y;
	}

	// kqX^[gZNg
	if ( this->key_state_buf[ KEY_INPUT_A ] == 1 )
	{
		this->current_mask |= this->BUTTON_L;
	}
	if ( this->key_state_buf[ KEY_INPUT_S ] == 1 )
	{
		this->current_mask |= this->BUTTON_R;
	}
	if ( this->key_state_buf[ KEY_INPUT_SPACE ] == 1 )
	{
		this->current_mask |= this->BUTTON_START;
	}
	if ( this->key_state_buf[ KEY_INPUT_RETURN ] == 1 )
	{
		this->current_mask |= this->BUTTON_SELECT;
	}
}
