// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef SDL_DRIVER_HPP
#define SDL_DRIVER_HPP

#if defined(__linux__)

#include <SDL.h>

namespace base_system {

class sdl_driver
{
public:
	sdl_driver();
	virtual ~sdl_driver();

	void print_joystick_property();
	::SDL_Surface* get_screen();
	::SDL_Joystick* get_joystick();

private:
	::SDL_Surface* screen;
	::SDL_Joystick* joystick;

	bool core_available;
	bool joystick_available;
	bool image_available;
	bool ttf_available;

	bool core_init();
	void core_quit();

	bool joystick_open();
	void joystick_close();

	bool image_init();
	void image_quit();

	bool ttf_init();
	void ttf_quit();
};

} // namespace base_system
namespace sys = base_system;

#endif // __linux__

#endif // SDL_DRIVER_HPP
