// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef INPUT_MASK_HPP
#define INPUT_MASK_HPP

namespace base_system {

#ifdef NO_DEF

enum input_mask
{
	AXIS_CENTER   = 0x00001000,
	AXIS_UP       = 0x00000001,
	AXIS_DOWN     = 0x00000002,
	AXIS_LEFT     = 0x00000004,
	AXIS_RIGHT    = 0x00000008,
	BUTTON_A      = 0x00000010,
	BUTTON_B      = 0x00000020,
	BUTTON_X      = 0x00000040,
	BUTTON_Y      = 0x00000080,
	BUTTON_L      = 0x00000100,
	BUTTON_R      = 0x00000200,
	BUTTON_START  = 0x00000400,
	BUTTON_SELECT = 0x00000800
};

enum class axis_mask
{
	AXIS_CENTER   = 0x00001000,
	AXIS_UP       = 0x00000001,
	AXIS_DOWN     = 0x00000002,
	AXIS_LEFT     = 0x00000004,
	AXIS_RIGHT    = 0x00000008
};

enum class button_mask
{
	BUTTON_A      = 0x00000010,
	BUTTON_B      = 0x00000020,
	BUTTON_X      = 0x00000040,
	BUTTON_Y      = 0x00000080,
	BUTTON_L      = 0x00000100,
	BUTTON_R      = 0x00000200,
	BUTTON_START  = 0x00000400,
	BUTTON_SELECT = 0x00000800
};

#endif // NO_DEF

} // namespace base_system
namespace sys = base_system;

#endif // INPUT_MASK_HPP
