// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "graphics/character_graphic.hpp"
#include "graphics/image.hpp"
#include "common/util.hpp"
#include "graphics/sprite.hpp"

character_graphic::character_graphic()
	: style( character_graphic::unknown ),
	  graphic(),
	  position( -1, -1 ),
	  base_image( nullptr ),
	  base_sprite( nullptr ),
	  base_index( -1 ),
	  base_position( -1, -1 )
{
}

character_graphic::character_graphic( image* base_image, point base_position )
	: style( character_graphic::use_image ),
	  graphic(),
	  position( -1, -1 ),
	  base_image( base_image ),
	  base_sprite( nullptr ),
	  base_index( -1 ),
	  base_position( base_position )
{
	this->reset();
}

character_graphic::character_graphic( sprite* base_sprite, int base_index, point base_position )
	: style( character_graphic::use_sprite ),
	  graphic(),
	  position( -1, -1 ),
	  base_image( nullptr ),
	  base_sprite( base_sprite ),
	  base_index( base_index ),
	  base_position( base_position )
{
	this->reset();
}

character_graphic::~character_graphic()
{
}

void character_graphic::init( image* base_image, point base_position )
{
	this->style         = this->use_image;
	this->graphic       = image()        ;
	this->position      = point( -1, -1 );
	this->base_image    = base_image     ;
	this->base_sprite   = nullptr        ;
	this->base_index    = -1             ;
	this->base_position = base_position  ;

	this->reset();
}

void character_graphic::init( sprite* base_sprite, int base_index, point base_position )
{
	this->style         = this->use_sprite;
	this->graphic       = image()         ;
	this->position      = point( -1, -1 ) ;
	this->base_image    = nullptr         ;
	this->base_sprite   = base_sprite     ;
	this->base_index    = base_index      ;
	this->base_position = base_position   ;

	this->reset();
}

void character_graphic::reset()
{
	if ( this->style == this->use_image )
	{
		this->graphic = *( this->base_image );
		this->position = this->base_position;
	}
	else if ( this->style == this->use_sprite )
	{
		this->set_graphic_using_sprite( this->base_index );
		this->position = this->base_position;
	}
}

void character_graphic::draw()
{
	this->graphic.draw( this->position, true );
}

void character_graphic::set_graphic_using_sprite( int index )
{
	this->base_sprite->recycle_image( &( this->graphic ), index );
}

void character_graphic::set_graphic_using_sprite( int x_chip, int y_chip )
{
	this->base_sprite->recycle_image( &( this->graphic ), x_chip, y_chip );
}
