// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef CHARACTER_STATUS_HPP
#define CHARACTER_STATUS_HPP

#include <cstdint>

class character_status
{
public:
	enum battle_position
	{
		front,
		back,
		unknown,
		sizeof_battle_position,
	};

	enum permanent_status : std::uint32_t
	{
		dead   = 1U <<  0,
		zombie = 1U <<  1,
	};

	enum temporary_status : std::uint32_t
	{
		poison  = 1U << 16,
		confuse = 1U << 17,
	};

	character_status();
	virtual ~character_status();

	void init_a( int level, int current_hp, int maximum_hp, int current_mp, int maximum_mp,
	             std::uint32_t perm_status, std::uint32_t temp_status, battle_position position );

	void init_b( int strength, int speed, int stamina, int magic, int attack,
	             int defense, int evasion, int magic_defense, int magic_evasion );

	void init_c( int ordering );

	void increase_hp_bounded      ( int delta );
	void increase_mp_bounded      ( int delta );

	void increase_hp_bounded_above( int delta );
	void increase_mp_bounded_above( int delta );

	void decrease_hp_bounded_below( int delta );
	void decrease_mp_bounded_below( int delta );

	bool is_dead  ();
	bool is_zombie();

	bool is_poison ();
	bool is_confuse();

	bool permanent_status_enabled( std::uint32_t mask );
	bool temporary_status_enabled( std::uint32_t mask );

	bool status_enabled( std::uint32_t mask );

	int             get_level      () { return this->level      ; }
	int             get_current_hp () { return this->current_hp ; }
	int             get_maximum_hp () { return this->maximum_hp ; }
	int             get_current_mp () { return this->current_mp ; }
	int             get_maximum_mp () { return this->maximum_mp ; }
	std::uint32_t   get_perm_status() { return this->perm_status; }
	std::uint32_t   get_temp_status() { return this->temp_status; }
	battle_position get_position   () { return this->position   ; }

	int get_strength     () { return this->strength     ; }
	int get_speed        () { return this->speed        ; }
	int get_stamina      () { return this->stamina      ; }
	int get_magic        () { return this->magic        ; }
	int get_attack       () { return this->attack       ; }
	int get_defense      () { return this->defense      ; }
	int get_evasion      () { return this->evasion      ; }
	int get_magic_defense() { return this->magic_defense; }
	int get_magic_evasion() { return this->magic_evasion; }

	int get_ordering() { return this->ordering; }

	void set_level      ( int             level       ) { this->level       = level      ; }
	void set_current_hp ( int             current_hp  ) { this->current_hp  = current_hp ; }
	void set_maximum_hp ( int             maximum_hp  ) { this->maximum_hp  = maximum_hp ; }
	void set_current_mp ( int             current_mp  ) { this->current_mp  = current_mp ; }
	void set_maximum_mp ( int             maximum_mp  ) { this->maximum_mp  = maximum_mp ; }
	void set_perm_status( std::uint32_t   perm_status ) { this->perm_status = perm_status; }
	void set_temp_status( std::uint32_t   temp_status ) { this->temp_status = temp_status; }
	void set_position   ( battle_position position    ) { this->position    = position   ; }

	void set_strength     ( int strength      ) { this->strength      = strength     ; }
	void set_speed        ( int speed         ) { this->speed         = speed        ; }
	void set_stamina      ( int stamina       ) { this->stamina       = stamina      ; }
	void set_magic        ( int magic         ) { this->magic         = magic        ; }
	void set_attack       ( int attack        ) { this->attack        = attack       ; }
	void set_defense      ( int defense       ) { this->defense       = defense      ; }
	void set_evasion      ( int evasion       ) { this->evasion       = evasion      ; }
	void set_magic_defense( int magic_defense ) { this->magic_defense = magic_defense; }
	void set_magic_evasion( int magic_evasion ) { this->magic_evasion = magic_evasion; }

	void set_ordering( int ordering ) { this->ordering = ordering; }

private:
	int level;

	int current_hp;
	int maximum_hp;

	int current_mp;
	int maximum_mp;

	std::uint32_t perm_status; // 퓬pXe[^X
	std::uint32_t temp_status; // 퓬̂ݗLȃXe[^X

	battle_position position;

	// Xe[^XQl
	// http://www.youtube.com/watch?v=WqQBAc-KCIE
	// http://www.youtube.com/watch?v=ipdSHSQbqxM
	// http://www.youtube.com/watch?v=ci21x2r7jIE
	// http://www.youtube.com/watch?v=28eVNchNk00

	int strength;       // 
	int speed;          // ΂₳ - agility
	int stamina;        // 傭
	int magic;          // ܂傭
	int attack;         // 傭
	int defense;        // ڂ
	int evasion;        // Ђ
	int magic_defense;  // ܂قڂ
	int magic_evasion;  // ܂قЂ

	int ordering; // p[eB[ł̏
};

#endif // CHARACTER_STATUS_HPP
