// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef CHARACTER_ID_HPP
#define CHARACTER_ID_HPP

class character_id
{
public:
	enum category
	{
		hero,
		enemy,
		unknown
	};

	enum hero_t
	{
		dino,
		milia,
		maria,
		jay,
		sizeof_hero_t,
		invalid_hero = -1
	};

	enum enemy_t
	{
		sizeof_enemy_t,
		invalid_enemy = -1
	};

	character_id();
	character_id( hero_t  hero_id  );
	character_id( enemy_t enemy_id );
	virtual ~character_id();

	void init( hero_t  hero_id  );
	void init( enemy_t enemy_id );

	bool is_hero () { return this->category_ == this->hero ; }
	bool is_enemy() { return this->category_ == this->enemy; }

	category get_category() { return this->category_; }
	hero_t   get_hero_id () { return this->hero_id  ; }
	enemy_t  get_enemy_id() { return this->enemy_id ; }

	void set_category( category category_ ) { this->category_ = category_; }
	void set_hero_id ( hero_t   hero_id   ) { this->hero_id   = hero_id  ; }
	void set_enemy_id( enemy_t  enemy_id  ) { this->enemy_id  = enemy_id ; }

private:
	category category_;
	hero_t   hero_id  ;
	enemy_t  enemy_id ;
};

#endif // CHARACTER_ID_HPP
