// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef ENEMY_BTL_HPP
#define ENEMY_BTL_HPP

#include "battle/battle_joiner.hpp"
#include "battle/enemy_status.hpp"
class character_id;
class character_grahic_btl;
class atb_gauge;

class enemy_btl : public battle_joiner
{
public:
	enemy_btl( enemy_status* status, enemy_status* init_status );
	enemy_btl( character_id* id, enemy_status* status, enemy_status* init_status, character_graphic_btl* graphic, atb_gauge* gauge );
	virtual ~enemy_btl();

	enemy_status* get_status     () { return this->current_status; }
	enemy_status* get_init_status() { return this->initial_status; }

	void set_status     ( enemy_status* status      ) { *( this->current_status ) = *status     ; }
	void set_init_status( enemy_status* init_status ) { *( this->initial_status ) = *init_status; }

private:
	enemy_status* current_status;
	enemy_status* initial_status;
};

#endif // ENEMY_BTL_HPP
