// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#ifndef BATTLE_OBJECT_FACTORY_HPP
#define BATTLE_OBJECT_FACTORY_HPP

class hero_btl;
class enemy_btl;
class hero_party_btl;
class enemy_party_btl;
#include <memory>

class battle_object_factory
{
public:
	static battle_object_factory* instance();

	hero_btl*  get_hero ();
	enemy_btl* get_enemy();

	hero_party_btl*  get_hero_party ();
	enemy_party_btl* get_enemy_party();

private:
	enum { capacity = 16 };

	std::unique_ptr< hero_btl  > hero_a [ capacity ];
	std::unique_ptr< enemy_btl > enemy_a[ capacity ];

	std::unique_ptr< hero_party_btl  > hero_party_a [ capacity / 2 ];
	std::unique_ptr< enemy_party_btl > enemy_party_a[ capacity / 2 ];

	void register_hero ( hero_btl*  hero  );
	void register_enemy( enemy_btl* enemy );

	void register_hero_party ( hero_party_btl*  hero_party  );
	void register_enemy_party( enemy_party_btl* enemy_party );

	battle_object_factory();
	virtual ~battle_object_factory();

	battle_object_factory( const battle_object_factory& );
	battle_object_factory& operator=( const battle_object_factory& );

	battle_object_factory( battle_object_factory&& );
	battle_object_factory& operator=( battle_object_factory&& );
};

#endif // BATTLE_OBJECT_FACTORY_HPP
