// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2012-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/battle_context.hpp"
#include "common/util.hpp"
#include "graphics/graphic_config.hpp"
#include "battle/hero_party_btl.hpp"
#include "battle/enemy_party_btl.hpp"
#include "battle/layered_updater_btl.hpp"
#include "battle/layered_drawer_btl.hpp"
#include "battle/atb_scheduler.hpp"
#include "battle/command_publisher.hpp"
#include "battle/battle_event_manager.hpp"
#include "common/general_queue.hpp"
class hero_btl;
class enemy_btl;
class battle_event;
#include "battle/hero_party_window.hpp"
#include "battle/enemy_party_window.hpp"
#include "battle/message_window.hpp"
#include "battle/command_window.hpp"
#include "battle/background_drawer.hpp"

namespace {

enum window_t
{
	hero,
	enemy,
	msg,
	cmd,
	sizeof_window_t
};

rectangle window_rect[ sizeof_window_t ] =
{
	rectangle( enemy_window_width, background_height, hero_window_width , info_window_height ),
	rectangle( 0                 , background_height, enemy_window_width, info_window_height ),
	rectangle( 0                 , 0                , canvas_width      , 32                 ),
	rectangle( cmd_window_left   , background_height, cmd_window_width  , info_window_height )
};

} // unnamed namespace

battle_context::battle_context()
	: updater(),
	  drawer(),
	  scheduler(),
	  commander(),
	  event_manager(),
	  hero_ready_queue(),
	  enemy_ready_queue(),
	  event_queue(),
	  hero_party(),
	  enemy_party(),
	  hero_window( ::window_rect[ ::hero ] ),
	  enemy_window( ::window_rect[ ::enemy ] ),
	  msg_window( ::window_rect[ ::msg ] ),
	  cmd_window( ::window_rect[ ::cmd ] ),
	  bg_drawer(),
{
}

battle_context::battle_context( hero_party_btl* hero_party, enemy_party_btl* enemy_party )
	: updater(),
	  drawer(),
	  scheduler(),
	  commander(),
	  event_manager(),
	  hero_ready_queue(),
	  enemy_ready_queue(),
	  event_queue(),
	  hero_party( *hero_party ),
	  enemy_party( *enemy_party ),
	  hero_window( ::window_rect[ ::hero ] ),
	  enemy_window( ::window_rect[ ::enemy ] ),
	  msg_window( ::window_rect[ ::msg ] ),
	  cmd_window( ::window_rect[ ::cmd ] ),
	  bg_drawer(),
{
}

battle_context::~battle_context()
{
}

void battle_context::init( hero_party_btl* hero_party, enemy_party_btl* enemy_party )
{
	this->updater     = layered_updater_btl();
	this->drawer      = layered_drawer_btl ();

	this->scheduler     = atb_scheduler       ();
	this->commander     = command_publisher   ();
	this->event_manager = battle_event_manager();

	this->hero_ready_queue  = general_queue< hero_btl*     >();
	this->enemy_ready_queue = general_queue< enemy_btl*    >();
	this->event_queue       = general_queue< battle_event* >();

	this->hero_party  = *hero_party ;
	this->enemy_party = *enemy_party;

	this->hero_window  = hero_party_window ( ::window_rect[ ::hero  ] );
	this->enemy_window = enemy_party_window( ::window_rect[ ::enemy ] );
	this->msg_window   = message_window    ( ::window_rect[ ::msg   ] );
	this->cmd_window   = command_window    ( ::window_rect[ ::cmd   ] );

	this->bg_drawer = background_drawer();
}
