// -*- coding: sjis; tab-width: 4; -*-

/* -----------------------------------------------------------------------
Copyright (c) 2011-2013 spinor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
----------------------------------------------------------------------- */

#include "battle/atb_scheduler.hpp"
#include "common/updatable.hpp"
#include "battle/hero_party_btl.hpp"
#include "battle/enemy_party_btl.hpp"
#include "common/general_queue.hpp"
#include "battle/hero_btl.hpp"
#include "battle/enemy_btl.hpp"
#include "battle/atb_gauge.hpp"
#include "common/hero_status.hpp"

atb_scheduler::atb_scheduler()
	: updatable(),
	  hero_party( nullptr ),
	  enemy_party( nullptr ),
	  hero_ready_queue( nullptr ),
	  enemy_ready_queue( nullptr )
{
}

atb_scheduler::~atb_scheduler()
{
}

void atb_scheduler::init( hero_party_btl*  hero_party,
                          enemy_party_btl* enemy_party,
                          general_queue< hero_btl*  >* hero_ready_queue,
                          general_queue< enemy_btl* >* enemy_ready_queue )
{
	this->hero_party  = hero_party ;
	this->enemy_party = enemy_party;

	this->hero_ready_queue  = hero_ready_queue ;
	this->enemy_ready_queue = enemy_ready_queue;
}

bool atb_scheduler::update()
{
	hero_btl*    hero   = nullptr;
	atb_gauge*   gauge  = nullptr;
	hero_status* status = nullptr;

	for ( hero_party_btl::iterator i = this->hero_party->begin() ;
	      i != this->hero_party->end() ;
	      ++i )
	{
		hero   = *i;
		gauge  = hero->get_gauge ();
		status = hero->get_status();

		if ( gauge->is_active() == false )
		{
			continue;
		}

		if ( gauge->is_maximum() == false )
		{
			gauge->increase_value_bounded( status->get_speed() );

			if ( gauge->is_maximum() == true )
			{
				this->hero_ready_queue->push( hero );
			}
		}
	}

	return true;
}
