package open.dolphin.message;

import java.util.List;

import open.dolphin.client.IChart;
import open.dolphin.utils.GUIDGenerator;
import open.dolphin.project.GlobalVariables;
/**
 * StringBuilder
 *
 * @author Kazushi Minagawa
 *
 */
public class DiseaseHelper {
        
    private String patientId;
    private String confirmDate;
    private String groupId;
    private String department;
    private String departmentDesc;
    private String creatorName;
    private String creatorId;
    private String creatorLicense;
    private String facilityName;
    private String jmariCode;
    private List diagnosisModuleItems;

    public DiseaseHelper(IChart context, String patientID, String confirmDate, List<DiagnosisModuleItem> moduleItems)
    {
      setPatientId(patientID);
      setConfirmDate(confirmDate);
      setDiagnosisModuleItems(moduleItems); 
      setGroupId(GUIDGenerator.generate(this));
      setDepartment(context.getPatientVisit().getDepartmentCode());
      setDepartmentDesc(context.getPatientVisit().getDepartmentName());
      setCreatorName(context.getPatientVisit().getAssignedDoctorName());
      setCreatorId(context.getPatientVisit().getAssignedDoctorId());
      setCreatorLicense(GlobalVariables.getUserModel().getLicenseModel().getLicense());
      setFacilityName(GlobalVariables.getUserModel().getFacility().getFacilityName());
      setJmariCode(context.getPatientVisit().getJmariCode());
    }

    /**
     *
     * @return
     */
    public String getPatientId() {
        return patientId;
    }

    private void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getConfirmDate() {
        return confirmDate;
    }

    private void setConfirmDate(String confirmDate) {
        this.confirmDate = confirmDate;
    }

    public String getGroupId() {
        return groupId;
    }

    private void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getDepartment() {
        return department;
    }

    private void setDepartment(String department) {
        this.department = department;
    }

    public String getDepartmentDesc() {
        return departmentDesc;
    }

    private void setDepartmentDesc(String departmentDesc) {
        this.departmentDesc = departmentDesc;
    }

    public String getCreatorName() {
        return creatorName;
    }

    private void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public String getCreatorId() {
        return creatorId;
    }

    private void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorLicense() {
        return creatorLicense;
    }

    private void setCreatorLicense(String creatorLicense) {
        this.creatorLicense = creatorLicense;
    }

    /**
     *
     * @return
     */
    public String getFacilityName() {
        return facilityName;
    }

    private void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public String getJmariCode() {
        return jmariCode;
    }

    private void setJmariCode(String jmariCode) {
        this.jmariCode = jmariCode;
    }

    public List getDiagnosisModuleItems() {
        return diagnosisModuleItems;
    }

    private void setDiagnosisModuleItems(List diagnosisModuleItems) {
        this.diagnosisModuleItems = diagnosisModuleItems;
    }
}
