package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import open.dolphin.log.LogWriter;
import open.dolphin.queries.DolphinQuery;
import org.hibernate.lob.BlobImpl;


/**
 * StampModel generated by hbm2java
 */
public class StampModel extends InfoModel {

     private String id;
     private long userId;
     private String entity;
     private Blob stampBlob;
     private byte[] stampBytes;

    public StampModel() {
    }

    public String getId() {
        return this.id;
    }
    
    public void setId(String id) {
        this.id = id;
    }
    public long getUserId() {
        return this.userId;
    }
    
    public void setUserId(long userid) {
        this.userId = userid;
    }
    public String getEntity() {
        return this.entity;
    }
    
    /**
     *
     * @param entity
     */
    public void setEntity(String entity) {
        this.entity = entity;
    }

    public byte[] getStampBytes() {
        return this.stampBytes;
    }

    /**
     *
     * @param stampBytes
     */
    public void setStampBytes(byte[] stampBytes) {
        this.stampBytes = stampBytes;
        if (stampBytes == null) {
            stampBytes = null;
        }
        else {
            this.stampBlob = new BlobImpl(stampBytes);
        }
    }

    public Blob getStampBlob() {
        return this.stampBlob;
    }
    
    /**
     *
     * @param stampBlob
     * @throws SQLException
     */
    public void setStampBlob(Blob stampBlob) throws SQLException {
        if (stampBlob != null) {
            this.stampBlob = stampBlob;
            this.stampBytes = stampBlob.getBytes(1, (int)stampBlob.length());
        }
    }

    /**
     *
     * @param query
     * @return
     */
    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public void initialize(String id, long userId, String entity, byte[] stampBytes) throws SQLException {
        setId(id);
        setUserId(userId);
        setEntity(entity);
        setStampBytes(stampBytes);
    }

    public void initialize(String id, long userId, String entity, String stampXml) {
        setId(id);
        setUserId(userId);
        setEntity(entity);
        setXml(stampXml);
    }

    public String getXml() {
        if (stampBytes != null) {
            try {
                return new String(stampBytes, "UTF-8");
            } catch (UnsupportedEncodingException ex) {
                   LogWriter.error(getClass(), ex);
            }
        }
        return "";
    }

    public void setXml(String xml) {
        if (xml != null) {
            try {
                stampBytes = xml.getBytes("UTF-8");
                if (stampBytes == null) {
                    stampBlob = null;
                }
                else {
                    stampBlob = new BlobImpl(stampBytes);
                }
            } catch (UnsupportedEncodingException ex) {
                   LogWriter.error(getClass(), ex);
            }
        }
    }

    public IInfoModel toInfoModel() {
        return ((IInfoModel) BeanUtils.xmlDecode(getStampBytes()));
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {

        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        final StampModel other = (StampModel)obj;
        if (!getId().equals(other.getId())) {
            return false;
        }
        return true;
    }

    /**
     *
     * @param result
     * @throws IOException
     */
    public void serialize(Writer result) throws IOException {
        //TODO serialize
    }

    public void deserialize(Writer result) throws IOException {
        //TODO deserialize
    }
}


