package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.persistence.Transient;
import open.dolphin.client.ChartWindow;
import open.dolphin.client.IChart;
import open.dolphin.utils.CombinedStringParser;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * PatientVisitModel generated by hbm2java
 */
public class PatientVisitModel extends InfoModel {

    public static final DataFlavor PVT_FLAVOR = new DataFlavor(open.dolphin.infomodel.PatientVisitModel.class, "Patient Visit");
    public static DataFlavor flavors[] = {PVT_FLAVOR};
    private long id;
    private PatientModel patient;
    private String facilityId;
    private String pvtDate;
    private String department;
    private int status;
    private String insuranceUid;
    @Transient
    private String appointment;
    @Transient
    private int number;

    public PatientVisitModel() {
    }

    /**
     *
     * @return
     */
    public long getId() {
        return this.id;
    }

    /**
     *
     * @param id
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     *
     * @return
     */
    public PatientModel getPatient() {
        return this.patient;
    }

    public void setAppointment(String appointment) {
        this.appointment = appointment;
    }

    /**
     * Reflection
     * @return
     */
    public String getAppointment() {
        return this.appointment;
    }

    /**
     *
     * @param patient
     */
    public void setPatient(PatientModel patient) {
        this.patient = patient;
    }

    /**
     *
     * @return
     */
    public String getFacilityId() {
        return this.facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    /**
     *
     * @param number
     */
    public void setNumber(int number) {
        this.number = number;
    }

    /**
     *
     * @return
     */
    public int getNumber() {
        return number;
    }

    public String getPvtDate() {
        return this.pvtDate;
    }

    public void setPvtDate(String pvtDate) {
        this.pvtDate = pvtDate;
    }

    public String getPvtDateTrimTime() {
        return ModelUtils.trimTime(pvtDate);
    }

    /**
     * Reflection
     * @return
     */
    public String getPvtDateTrimDate() {
        return ModelUtils.trimDate(pvtDate);
    }

    /**
     * Reflection
     * @return
     */
    public String getDepartmentName() {
        // MEMO: Need to check this method
        //       Obsolute method for 1.3
        String[] tokens = tokenizeDept(department);
        return tokens[0];
    }

    public String getDepartment() {
        return department;
    }

    /**
     *
     * @param department
     */
    public void setDepartment(String department) {
        this.department = department;
    }

    /**
     * Reflection
     * @return
     */
    public String getCategory() {
        // MEMO: Need to check this method
        //       Obsolute method for 1.3
        String[] tokens = tokenizeDept(department);
        return tokens[5];
    }

    public String getDepartmentCode() {
        // MEMO: Need to check this method
        //       Obsolute method for 1.3
        String[] tokens = tokenizeDept(department);
        return tokens[1];
    }

    /**
     *
     * @return
     */
    public String getAssignedDoctorName() {
        // MEMO: Need to check this method
        //       Obsolute method for 1.3
        String[] tokens = tokenizeDept(department);
        return tokens[2];
    }

    /**
     *
     * @return
     */
    public String getAssignedDoctorId() {
        // MEMO: Need to check this method
        //       Obsolute method for 1.3
        String[] tokens = tokenizeDept(department);
        return tokens[3];
    }

    public String getJmariCode() {
        // MEMO: Need to check this method
        //       Obsolute method for 1.3
        String[] tokens = tokenizeDept(department);
        return tokens[4];
    }

    /**
     *
     * @return
     */
    public String getDeptNoTokenize() {
        return department;
    }

    private String[] tokenizeDept(String dept) {

        // MEMO: Department を分割して配列にする
        //       診療科名、コード、担当医名、担当医コード、JMARI コード, 診療内容
        CombinedStringParser line = new CombinedStringParser(',', dept);
        String[] result = new String[line.size()];
        for (int index = 0; index < line.size(); index++) {
            result[index] = line.get(index);
        }
        return result;
    }

    public int getStatus() {
        return this.status;
    }
    /**
     *
     * @param status
     */
    public void setStatus(int status) {
        this.status = status;
    }

    public void setState(IChart.state status) {
        switch (status) {
            case CLOSE_NONE:
                this.status = 0;
                break;
            case CLOSE_SAVE:
                this.status = 1;
                break;
            case OPEN_NONE:
                this.status = 2;
                break;
            case OPEN_SAVE:
                this.status = 3;
                break;
            case CANCEL_PVT:
                this.status = -1;
                break;
        }
    }

    /**
     * Reflection
     * @return
     */
    //   public Integer getState() {
//        return new Integer(status);
    //  }
    public IChart.state getState() {
        switch (status) {
            case -1:
                return IChart.state.CANCEL_PVT;
            case 0:
                return IChart.state.CLOSE_NONE;
            case 1:
                return IChart.state.CLOSE_SAVE;
            case 2:
                return IChart.state.OPEN_NONE;
            case 3:
                return IChart.state.OPEN_SAVE;
        }
        return IChart.state.CLOSE_NONE;
    }

    /**
     * Reflection
     * @return
     */
    public String getPatientId() {
        return getPatient().getPatientId();
    }

    /**
     * Reflection
     * @return
     */
    public String getPatientName() {
        return getPatient().getFullName();
    }

    /**
     * Reflection
     * @return
     */
    public String getPatientGenderDesc() {
        return ModelUtils.getGenderDesc(getPatient().getGender());
    }

    public String getMemo() {
        return ModelUtils.getMemo(getPatient().getMemo());
    }

    /**
     * Reflection
     * @return
     */
    public String getPatientAgeBirthday() {
        return ModelUtils.getAgeBirthday(getPatient().getBirthday());
    }

    /**
     *
     * @return
     */
    public String getPatientBirthday() {
        return getPatient().getBirthday();
    }

    /**
     *
     * @return
     */
    public String getPatientAge() {
        return ModelUtils.getAge(getPatient().getBirthday());
    }

    public String getInsuranceUid() {
        return this.insuranceUid;
    }

    public void setInsuranceUid(String insuranceuid) {
        this.insuranceUid = insuranceuid;
    }

    /**
     *
     * @param df
     * @return
     */
    public boolean isDataFlavorSupported(DataFlavor df) {
        return df.equals(PVT_FLAVOR);
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (df.equals(PVT_FLAVOR)) {
            return this;
        } else {
            throw new UnsupportedFlavorException(df);
        }
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
