package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Transient;
import open.dolphin.queries.DolphinQuery;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * PatientModel generated by hbm2java
 */
public class PatientModel extends InfoModel implements IPatientModel {

    private long id;
    private String facilityId;
    private String patientId;
    private String familyName;
    private String givenName;
    private String fullName;
    private String kanaFamilyName;
    private String kanaGivenName;
    private String kanaName;
    private String romanFamilyName;
    private String romanGivenName;
    private String romanName;
    private String gender;
    private String genderDesc;
    @Transient
    private String genderCodeSys;
    private String birthday;
    private String nationality;
    @Transient
    private String nationalityDesc;
    @Transient
    private String nationalityCodeSys;
    private String maritalStatus;
    @Transient
    private String maritalStatusDesc;
    @Transient
    private String maritalStatusCodeSys;
    private byte[] jpegPhoto;
    private String memo;
    @Embedded
    private SimpleAddressModel address;
    private String telephone;
    private String mobilePhone;
    private String email;
    private Set<HealthInsuranceModel> healthInsurances;
    @Transient
    private List<PVTHealthInsuranceModel> pvtHealthInsurances;
    @Transient
    private List<AddressModel> addresses;
    @Transient
    private List<TelephoneModel> telephones;

    public PatientModel() {
        healthInsurances = new LinkedHashSet<HealthInsuranceModel>();
        pvtHealthInsurances = new ArrayList<PVTHealthInsuranceModel>(2);
        telephones = new ArrayList<TelephoneModel>(1);
        addresses = new ArrayList<AddressModel>(1);
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFacilityId() {
        return facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    @Override
    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    @Override
    public String getPatientId() {
        return patientId;
    }

    public void setFamilyName(String sirName) {
        this.familyName = sirName;
    }

    public String getFamilyName() {
        return familyName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getGivenName() {
        return givenName;
    }

    @Override
    public void setFullName(String name) {
        this.fullName = name;
    }

    @Override
    public String getFullName() {
        return fullName;
    }

    public void setKanaFamilyName(String kanaSirName) {
        this.kanaFamilyName = kanaSirName;
    }

    /**
     *
     * @return
     */
    public String getKanaFamilyName() {
        return kanaFamilyName;
    }

    public void setKanaGivenName(String kanaGivenName) {
        this.kanaGivenName = kanaGivenName;
    }

    public String getKanaGivenName() {
        return kanaGivenName;
    }

    public void setKanaName(String kanaName) {
        this.kanaName = kanaName;
    }

    /**
     *
     * @return
     */
    public String getKanaName() {
        return kanaName;
    }

    public void setRomanFamilyName(String romanSirName) {
        this.romanFamilyName = romanSirName;
    }

    public String getRomanFamilyName() {
        return romanFamilyName;
    }

    public void setRomanGivenName(String romanGivenName) {
        this.romanGivenName = romanGivenName;
    }

    public String getRomanGivenName() {
        return romanGivenName;
    }

    /**
     *
     * @param romanName
     */
    public void setRomanName(String romanName) {
        this.romanName = romanName;
    }

    public String getRomanName() {
        return romanName;
    }

    @Override
    public void setGender(String gender) {
        this.gender = gender;
    }

    @Override
    public String getGender() {
        return gender;
    }

    @Override
    public void setGenderDesc(String genderDesc) {
        this.genderDesc = genderDesc;
    }

    @Override
    public String getGenderDesc() {
        return genderDesc != null
                ? genderDesc
                : ModelUtils.getGenderDesc(gender);
    }

    @Override
    public void setGenderCodeSys(String genderCodeSys) {
        this.genderCodeSys = genderCodeSys;
    }

    @Override
    public String getGenderCodeSys() {
        return genderCodeSys;
    }

    @Override
    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    @Override
    public String getBirthday() {
        return birthday;
    }

    public String getAgeBirthday() {
        return ModelUtils.getAgeBirthday(birthday);
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public String getNationality() {
        return nationality;
    }

    public void setNationalityDesc(String nationalityDesc) {
        this.nationalityDesc = nationalityDesc;
    }

    public String getNationalityDesc() {
        return nationalityDesc;
    }

    public void setNationalityCodeSys(String nationalityCodeSys) {
        this.nationalityCodeSys = nationalityCodeSys;
    }

    /**
     *
     * @return
     */
    public String getNationalityCodeSys() {
        return nationalityCodeSys;
    }

    /**
     *
     * @param maritalStatus
     */
    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public String getMaritalStatus() {
        return maritalStatus;
    }

    public void setMaritalStatusDesc(String maritalStatusDesc) {
        this.maritalStatusDesc = maritalStatusDesc;
    }

    public String getMaritalStatusDesc() {
        return maritalStatusDesc;
    }

    public void setMaritalStatusCodeSys(String maritalStatusCodeSys) {
        this.maritalStatusCodeSys = maritalStatusCodeSys;
    }

    /**
     *
     * @return
     */
    public String getMaritalStatusCodeSys() {
        return maritalStatusCodeSys;
    }

    public void setJpegPhoto(byte[] jpegPhoto) {
        this.jpegPhoto = jpegPhoto;
    }

    public byte[] getJpegPhoto() {
        return jpegPhoto;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMemo() {
        return memo;
    }

    /**
     *
     * @return
     */
    public SimpleAddressModel getAddress() {
        return address;
    }

    /**
     *
     * @param address
     */
    public void setAddress(SimpleAddressModel address) {
        this.address = address;
    }

    public String contactZipCode() {
        return (address != null) ? address.getZipCode() : null;
    }

    public String contactAddress() {
        return (address != null) ? address.getAddress() : null;
    }

    /**
     *
     * @return
     */
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setHealthInsurances(Set<HealthInsuranceModel> healthInsurances) {
        this.healthInsurances = healthInsurances;
        if (this.healthInsurances != null) {
            for (HealthInsuranceModel insurance : this.healthInsurances) {
                insurance.setPatient(this);
            }
        }
    }

    public Set<HealthInsuranceModel> getHealthInsurances() {
        return healthInsurances;
    }

    public void addHealthInsurance(HealthInsuranceModel healthInsurance) {
        if (healthInsurances == null) {
            healthInsurances = new LinkedHashSet<HealthInsuranceModel>();
        }
        healthInsurances.add(healthInsurance);
    }

    public List<PVTHealthInsuranceModel> getPvtHealthInsurances() {
        return pvtHealthInsurances;
    }

    public void setPvtHealthInsurances(List<PVTHealthInsuranceModel> pvtHealthInsurances) {
        this.pvtHealthInsurances = pvtHealthInsurances;
    }

    /**
     *
     * @param model
     */
    public void addPvtHealthInsurance(PVTHealthInsuranceModel model) {
        //    if (pvtHealthInsurances == null) {
        //        pvtHealthInsurances = new ArrayList<PVTHealthInsuranceModel>(2);
        //     }
        pvtHealthInsurances.add(model);
    }

    /**
     *
     * @return
     */
    public List<AddressModel> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<AddressModel> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(AddressModel address) {
        //    if (addresses == null) {
        //         addresses = new ArrayList<AddressModel>(1);
        //    }
        addresses.add(address);
    }

    public List<TelephoneModel> getTelephones() {
        return telephones;
    }

    public void setTelephones(List<TelephoneModel> telephones) {
        this.telephones = telephones;
    }

    public void addTelephone(TelephoneModel telephone) {
        //      if (telephones == null) {
        //       telephones = new ArrayList<TelephoneModel>(1);
        //   }
        telephones.add(telephone);
    }

    public PatientLiteModel patientAsLiteModel() {
        PatientLiteModel model = new PatientLiteModel();
        model.setPatientId(getPatientId());
        model.setFullName(getFullName());
        model.setGender(getGender());
        model.setGenderDesc(getGenderDesc());
        model.setGenderCodeSys(getGenderCodeSys());
        model.setBirthday(getBirthday());
        return model;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + (int) (id ^ (id >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PatientModel other = (PatientModel) obj;
        if (getId() != other.getId()) {
            return false;
        }
        return true;
    }
}
