/*
 * OrcaInputCd.java
 * Copyright (C) 2007 Digital Globe, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import open.dolphin.infomodel.InfoModel;
import open.dolphin.queries.DolphinQuery;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ORCA の tbl_inputcd エンティティクラス。
 *
 * @author Minagawa, Kazushi
 */
public class OrcaInputCd extends InfoModel {//id

    private String hospId;
    private String cdsyu;
    private String inputCd;
    private String sryKbn;
    private String sryCd;
    private int dspSeq;
    private String dspName;
    private String termId;
    private String opId;
    private String creYmd;
    private String upYmd;
    private String upHms;
    private List<OrcaInputSet> inputSet;

    /** 
     * Creates a new instance of OrcaInputCd 
     */
    public OrcaInputCd() {
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    /**
     *
     * @return
     */
    public String getHospId() {
        return hospId;
    }

    /**
     *
     * @param hospId
     */
    public void setHospId(String hospId) {
        this.hospId = hospId;
    }

    public String getCdsyu() {
        return cdsyu;
    }

    public void setCdsyu(String cdsyu) {
        this.cdsyu = cdsyu;
    }

    public String getInputCd() {
        return inputCd;
    }

    /**
     *
     * @param inputCd
     */
    public void setInputCd(String inputCd) {
        this.inputCd = inputCd;
    }

    public String getSryKbn() {
        return sryKbn;
    }

    /**
     *
     * @param sryKbn
     */
    public void setSryKbn(String sryKbn) {
        this.sryKbn = sryKbn;
    }

    /**
     *
     * @return
     */
    public String getSryCd() {
        return sryCd;
    }

    public void setSryCd(String sryCd) {
        this.sryCd = sryCd;
    }

    public int getDspSeq() {
        return dspSeq;
    }

    public void setDspSeq(int dspSeq) {
        this.dspSeq = dspSeq;
    }

    public String getDspName() {
        return dspName;
    }

    public void setDspName(String dspName) {
        this.dspName = dspName;
    }

    /**
     *
     * @return
     */
    public String getTermId() {
        return termId;
    }

    /**
     *
     * @param termId
     */
    public void setTermId(String termId) {
        this.termId = termId;
    }

    public String getOpId() {
        return opId;
    }

    /**
     *
     * @param opId
     */
    public void setOpId(String opId) {
        this.opId = opId;
    }

    public String getCreYmd() {
        return creYmd;
    }

    public void setCreYmd(String creYmd) {
        this.creYmd = creYmd;
    }

    public String getUpYmd() {
        return upYmd;
    }

    public void setUpYmd(String upYmd) {
        this.upYmd = upYmd;
    }

    /**
     *
     * @return
     */
    public String getUpHms() {
        return upHms;
    }

    public void setUpHms(String upHms) {
        this.upHms = upHms;
    }

    public List<OrcaInputSet> getInputSet() {
        return inputSet;
    }

    public void setInputSet(List<OrcaInputSet> list) {
        inputSet = list;
    }

    /**
     *
     * @param set
     */
    public void addInputSet(OrcaInputSet set) {
        if (inputSet == null) {
            inputSet = new ArrayList<OrcaInputSet>();
        }
        inputSet.add(set);
    }

    public ModuleInfoBean getStampInfo() {
        ModuleInfoBean ret = new ModuleInfoBean();
        ret.initialize(getInputCd(), getDspName(), null, ENTITY_MED_ORDER, ROLE_ORCA_SET);

        //    ret.setStampName(getDspName());
        //    ret.setStampRole(ROLE_ORCA_SET);
        //    ret.setEntity(ENTITY_MED_ORDER);
        //    ret.setStampId(getInputCd());
        return ret;
    }

    public BundleMed getBundleMed() {

        BundleMed ret = new BundleMed();

        for (OrcaInputSet set : inputSet) {

            ret.addClaimItem(set.getClaimItem());
        }
        return ret;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public void serialize(Writer result) throws IOException {
        //TODO serialize
    }

    public void deserialize(Writer result) throws IOException {
        //TODO deserialize
    }
}
