/*
 * IStampInfo.java
 * Copyright (C) 2002 Dolphin Project. All rights reserved.
 * Copyright (C) 2004 Digital Globe, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *	
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *	
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.queries.DolphinQuery;

public interface IStampInfo {

    public boolean search(DolphinQuery query);

    public void initialize(String stampId, String name, String text, String entity, String _role);

    /**
     *
     * @return
     */
    public String getStampName();

    /**
     *
     * @param text
     */
    public void setStampName(String text);

    public String getStampRole();

    public void setStampRole(String _role);

    public String getStampStatus();

    public void setStampStatus(String status);

    /**
     *
     * @return
     */
    public String getEntity();

    public void setEntity(String entity);

    public boolean isSerialized();

    public boolean isASP();

    public void setASP(boolean asp);

    /**
     *
     * @return
     */
    public String getStampId();

    public void setStampId(String id);

    /**
     *
     * @return
     */
    public String getStampMemo();

    public void setStampMemo(String memo);

    /**
     *
     * @param editable
     */
    public void setEditable(boolean editable);

    /**
     *
     * @return
     */
    public boolean isEditable();

    public void setTurnIn(boolean turnIn);

    public boolean isTurnIn();

    public String toString();

    public void setStampNumber(int stampNumber);

    public int getStampNumber();

    public int compareTo(Object other);

    public void serialize(Writer result) throws IOException;
}