package open.dolphin.infomodel;
// Generated 2010/06/30 10:57:59 by Hibernate Tools 3.2.1.GA

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * DocumentModel generated by hbm2java
 */
public class DocumentModel extends KarteEntryBean {

    private DocInfoModel docInfo;

    private Set<ModuleModel> modules;

    private Set<SchemaModel> schemas;

    public DocumentModel() {
        setDocInfo(new DocInfoModel());
        getDocInfo().setDocType(DOCTYPE_KARTE);
    }

    /**
     *
     */
    public void toDetuch() {
        if (docInfo != null) {
            docInfo.setDocPk(getId());
            docInfo.setParentPk(getLinkId());
            docInfo.setConfirmDate(getConfirmed());
            docInfo.setFirstConfirmDate(getStarted());
            docInfo.setStatus(getStatus());
        }
    }

    public void toPersist() {
        if (docInfo != null) {
            setLinkId(docInfo.getParentPk());
            setLinkRelation(docInfo.getParentIdRelation());
            setConfirmed(docInfo.getConfirmDate());
            setFirstConfirmed(docInfo.getFirstConfirmDate());
            setStatus(docInfo.getStatus());
        }
    }

    public DocInfoModel getDocInfo() {
        return docInfo;
    }

    public void setDocInfo(DocInfoModel docInfo) {
        this.docInfo = docInfo;
    }

    public Set<SchemaModel> getSchemas() {
        return schemas;
    }

    public void setSchemas(Set<SchemaModel> images) {
        this.schemas = images;
    }

    public void addSchema(SchemaModel model) {
        if (this.schemas == null) {
            this.schemas = new LinkedHashSet<SchemaModel>();
        }
        this.schemas.add(model);
    }

    public void clearSchema() {
        if (schemas != null && schemas.size() > 0) {
            schemas.clear();
        }
    }

    public SchemaModel getSchema(int index) {
        if (schemas != null && schemas.size() > 0) {
            int cnt = 0;
            for (SchemaModel bean : schemas) {
                if (index == cnt) {
                    return bean;
                }
                cnt++;
            }
        }
        return null;
    }

    /**
     *
     * @return
     */
    public Set<ModuleModel> getModules() {
        return modules;
    }

    public void setModules(Set<ModuleModel> modules) {
        this.modules = modules;
    }

    public void addModule(ModuleModel[] addArray) {
        if (modules == null) {
            modules = new LinkedHashSet<ModuleModel>();
        }
        modules.addAll(Arrays.asList(addArray));
    }

    /**
     *
     * @param addModule
     */
    public void addModule(ModuleModel addModule) {
        if (modules == null) {
            modules = new LinkedHashSet<ModuleModel>();
        }
        modules.add(addModule);
    }

    public void clearModules() {
        if (modules != null && modules.size() > 0) {
            modules.clear();
        }
    }

    public ModuleModel getModule(String entityName) {
        if (modules != null) {
            ModuleModel ret = null;
            for (ModuleModel model : modules) {
              if (model.getModuleInfo() != null){
                if (model.getModuleInfo().getEntity().equals(entityName)) {
                    ret = model;
                    break;
                }
                }
            }
            return ret;
        }
        return null;
    }

    /**
     *
     * @param entityName
     * @return
     */
    public IStampInfo[] getModuleInfo(String entityName) {
        Set<IStampInfo> result = new LinkedHashSet<IStampInfo>(2);
        if (modules != null) {
            for (ModuleModel model : modules) {
                if (model.getModuleInfo().getEntity().equals(entityName)) {
                    result.add(model.getModuleInfo());
                }
            }
            if (result.size() > 0) {
                return (IStampInfo[]) result.toArray(new ModuleInfoBean[result.size()]);
            }
        }
        return null;
    }

    @Override
    public void serialize(Writer result) throws IOException {
        result.append("<DocumentModel>");
        result.append(System.getProperty("line.separator"));
        super.serialize(result);
        if (docInfo != null) {
            docInfo.serialize(result);
        }
        if (modules != null) {
            result.append("<Modules>");
            result.append(System.getProperty("line.separator"));
            for (ModuleModel module : modules) {
                module.serialize(result);
            }
            result.append("</Modules>");
            result.append(System.getProperty("line.separator"));
        }
        if (schemas != null) {
            result.append("<Schemas>");
            result.append(System.getProperty("line.separator"));
            for (SchemaModel _schema : schemas) {
                _schema.serialize(result);
            }
            result.append("</Schemas>");
            result.append(System.getProperty("line.separator"));
        }
        result.append("</DocumentModel>");
        result.append(System.getProperty("line.separator"));
    }
}


