package open.dolphin.infomodel;

import java.io.IOException;
import java.io.Writer;
import open.dolphin.queries.DolphinQuery;

public class BundleImage extends BundleDolphin {//id

    private static final long serialVersionUID = -8747202550129389856L;//2/26
    private ClaimItem radItem;

    public BundleImage() {
    }

    @Override
    public boolean search(DolphinQuery query) {
        return false;
    }

    @Override
    public void addClaimItem(ClaimItem val) {
        if (val instanceof ClaimItem) {
            if (val.getCode().startsWith("700")) {
                radItem = val;
                for (int i = 0; i < claimItems.length; i++) {
                    if (!claimItems[i].getCode().startsWith("002")) {
                        claimItems[i].setNumber(radNumber());
                    }
                }
            } else if (radItem instanceof ClaimItem) {
                if (!val.getCode().startsWith("002")) {
                    val.setNumber(radNumber());
                }
            }
        }
        super.addClaimItem(val);
    }

    private String radNumber() {
        float suryo1 = radItem.getSuryo1();
        float suryo2 = radItem.getSuryo2();
        return Float.toString(suryo1 * suryo2);
    }

    @Override
    public void serialize(Writer result) throws IOException {
        //TODO serialize
    }

    /**
     *
     * @param result
     * @throws IOException
     */
    @Override
    public void deserialize(Writer result) throws IOException {
        //TODO deserialize
    }
}
