package open.dolphin.dao;

import java.sql.*;
import open.dolphin.log.LogWriter;
import open.dolphin.project.GlobalVariables;

/**
 * SqlDaoBean
 *
 * @author  Kazushi Minagawa
 */
public class SqlDaoBean extends DaoBean {

    String dataBase;
    String driver;
    boolean trace = true;

    /** 
     * Creates a new instance of SqlDaoBean 
     */
    public SqlDaoBean() {
        super();
    }

    public String getDriver() {
        return driver;
    }

    public void setDriver(String driver) {

        this.driver = driver;
        try {
            Class.forName(driver);

        } catch (ClassNotFoundException cnfe) {
      //      LogWriter.warn(getClass(), "Couldn't find the driver!");
        //    LogWriter.warn(getClass(), "Let's print a stack trace, and exit.");
            //           System.exit(1);
        }
    }

    public String getDatabase() {
        return dataBase;
    }

    /**
     *
     * @param base
     */
    public void setDatabase(String base) {
        dataBase = base;
    }

    protected String getURL() {
        StringBuffer buf = new StringBuffer();
        buf.append("jdbc:postgresql://");
        buf.append(host);
        buf.append(":");
        buf.append(port);
        buf.append("/");
        buf.append(dataBase);
        return buf.toString();
    }
    
    /**
     *
     * @return
     */
    public boolean getTrace() {
        return trace;
    }

    /**
     *
     * @param b
     */
    public void setTrace(boolean b) {
        trace = b;
    }

    /**
     *
     * @return
     * @throws Exception
     */
    public Connection getConnection() throws Exception {
        return DriverManager.getConnection(getURL(), user, passwd);
    }

    public String addSingleQuote(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        buf.append(s);
        buf.append("'");
        return buf.toString();
    }

    /**
     * To make sql statement ('xxxx',)<br>
     * @return
     */
    public String addSingleQuoteComa(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        buf.append(s);
        buf.append("',");
        return buf.toString();
    }

    public void closeStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            } catch (SQLException e) {
                    LogWriter.error(getClass(), e);
            }
        }
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            } catch (SQLException e) {
                    LogWriter.error(getClass(), e);
            }
        }
    }

    protected int getHospNumFromOrca() {

        Connection con = null;
        Statement st = null;
        String sql = null;
        int hospNum = 1;
        String jmari = GlobalVariables.getJMARICode();

        StringBuilder sb = new StringBuilder();
        sb.append("select hospnum, kanritbl from tbl_syskanri where kanricd='1001' and kanritbl like '%");
        sb.append(jmari);
        sb.append("%'");
        sql = sb.toString();

        try {
            con = getConnection();
            st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                hospNum = rs.getInt(1);
            }

        } catch (Exception e) {
            processError(e);
            closeConnection(con);
            closeStatement(st);
        }
        return hospNum;
    }
}
