/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SendMmlSettingPanel.java
 *
 * Created on 2010/03/10, 15:51:29
 */
package open.dolphin.client.settings;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;

import open.dolphin.client.AutoRomanListener;
import open.dolphin.project.GlobalVariables;
import open.dolphin.utils.Adapter;

/**
 *
 *
 * @author oda
 */
public class SendMmlSettingPanel extends javax.swing.JPanel implements IAbstractSettingPanel {

    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    protected State state = State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "mmlSetting";
    private static final String TITLE = "MML出力";
    private static final String ICON = "cd_24.gif";
    private MmlModel model;
    private StateMgr stateMgr;
    private Adapter<Boolean, Boolean> adapter;

    /** Creates new form SendMmlSettingPanel */
    public SendMmlSettingPanel() {
        boundSupport = new PropertyChangeSupport(this);
        initComponents();

        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bg1 = new javax.swing.ButtonGroup();
        bg2 = new javax.swing.ButtonGroup();
        content = new javax.swing.JPanel();
        panel1 = new javax.swing.JPanel();
        sendMML = new javax.swing.JRadioButton();
        sendNoMML = new javax.swing.JRadioButton();
        label1 = new javax.swing.JLabel();
        panel2 = new javax.swing.JPanel();
        mml23 = new javax.swing.JRadioButton();
        mml3 = new javax.swing.JRadioButton();
        label2 = new javax.swing.JLabel();
        label3 = new javax.swing.JLabel();
        protocolCombo = new javax.swing.JComboBox();
        uploaderServer = new javax.swing.JTextField();
        label4 = new javax.swing.JLabel();
        shareDirectory = new javax.swing.JTextField();

        setLayout(new java.awt.GridLayout(1, 0));

        content.setBorder(javax.swing.BorderFactory.createTitledBorder("MML(XML)出力"));
        content.setName("content"); // NOI18N

        panel1.setName("panel1"); // NOI18N
        panel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 0, 5));

        bg1.add(sendMML);
        sendMML.setText("する");
        sendMML.setName("sendMML"); // NOI18N
        sendMML.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendMMLActionPerformed(evt);
            }
        });
        panel1.add(sendMML);

        bg1.add(sendNoMML);
        sendNoMML.setText("しない");
        sendNoMML.setName("sendNoMML"); // NOI18N
        sendNoMML.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendNoMMLActionPerformed(evt);
            }
        });
        panel1.add(sendNoMML);

        label1.setText("MML バージョン:");
        label1.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        label1.setName("label1"); // NOI18N

        panel2.setName("panel2"); // NOI18N
        panel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 0, 5));

        bg2.add(mml23);
        mml23.setText("2.3");
        mml23.setName("mml23"); // NOI18N
        panel2.add(mml23);

        bg2.add(mml3);
        mml3.setText("3.0");
        mml3.setName("mml3"); // NOI18N
        panel2.add(mml3);

        label2.setText("送信プロトコル:");
        label2.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        label2.setName("label2"); // NOI18N

        label3.setText("送信サーバアドレス:");
        label3.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        label3.setName("label3"); // NOI18N

        protocolCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Samba" }));
        protocolCombo.setName("protocolCombo"); // NOI18N

        uploaderServer.setColumns(10);
        uploaderServer.setName("uploaderServer"); // NOI18N

        label4.setText("送信先ディレクトリ:");
        label4.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        label4.setName("label4"); // NOI18N

        shareDirectory.setColumns(10);
        shareDirectory.setName("shareDirectory"); // NOI18N

        javax.swing.GroupLayout contentLayout = new javax.swing.GroupLayout(content);
        content.setLayout(contentLayout);
        contentLayout.setHorizontalGroup(
            contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(contentLayout.createSequentialGroup()
                .addGap(89, 89, 89)
                .addGroup(contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(label1)
                    .addComponent(label4)
                    .addComponent(label3)
                    .addComponent(label2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(shareDirectory)
                    .addComponent(protocolCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(panel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(panel2, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, contentLayout.createSequentialGroup()
                        .addComponent(uploaderServer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(4, 4, 4)))
                .addGap(205, 205, 205))
        );
        contentLayout.setVerticalGroup(
            contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(contentLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(panel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(contentLayout.createSequentialGroup()
                        .addGap(8, 8, 8)
                        .addComponent(label1))
                    .addGroup(contentLayout.createSequentialGroup()
                        .addComponent(panel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(protocolCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(label2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(label3)
                            .addComponent(uploaderServer, javax.swing.GroupLayout.PREFERRED_SIZE, 19, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(contentLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(label4)
                    .addComponent(shareDirectory, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(194, 194, 194))
        );

        add(content);
    }// </editor-fold>//GEN-END:initComponents

    private void sendMMLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendMMLActionPerformed
        stateMgr.controlSendMml();
    }//GEN-LAST:event_sendMMLActionPerformed

    private void sendNoMMLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendNoMMLActionPerformed
        stateMgr.controlSendMml();
    }//GEN-LAST:event_sendNoMMLActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bg1;
    private javax.swing.ButtonGroup bg2;
    private javax.swing.JPanel content;
    private javax.swing.JLabel label1;
    private javax.swing.JLabel label2;
    private javax.swing.JLabel label3;
    private javax.swing.JLabel label4;
    private javax.swing.JRadioButton mml23;
    private javax.swing.JRadioButton mml3;
    private javax.swing.JPanel panel1;
    private javax.swing.JPanel panel2;
    private javax.swing.JComboBox protocolCombo;
    private javax.swing.JRadioButton sendMML;
    private javax.swing.JRadioButton sendNoMML;
    private javax.swing.JTextField shareDirectory;
    private javax.swing.JTextField uploaderServer;
    // End of variables declaration//GEN-END:variables

    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }
    /**
     * MML出力を開始する。
     */
    @Override
    public void start() {
        //    projectStub = GlobalVariables.getGlobalVariables();
        model = new MmlModel();
        model.populate();
    }

    /**
     * 保存する。
     */
    @Override
    public void save() {
        model.restore();
    }

    public void connect() {

        stateMgr = new StateMgr();

        // テキストフィールドのイベントがあったら　State check を行う
        DocumentListener dl = new DocumentListener() {

            @Override
            public void insertUpdate(DocumentEvent e) {
                stateMgr.checkState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                stateMgr.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                stateMgr.checkState();
            }
        };

        uploaderServer.getDocument().addDocumentListener(dl);
        shareDirectory.getDocument().addDocumentListener(dl);

        // IME OFF FocusAdapter
             
        uploaderServer.addFocusListener(AutoRomanListener.getInstance());
        shareDirectory.addFocusListener(AutoRomanListener.getInstance());
        

        stateMgr.controlSendMml();

    }

    /**
     *
     * @return
     */
    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     *
     * @return
     */
    @Override
    public ProjectSettingDialog getContext() {
        return context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener(STATE_PROP, context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    /**
     * @param state The state to set.
     */
    @Override
    public void setState(State state) {
        this.state = state;
        boundSupport.firePropertyChange(STATE_PROP, null, this.state);
    }

    /**
     * @return Returns the state.
     */
    @Override
    public State getState() {
        return state;
    }

    class MmlModel {

        public void populate() {
            boolean sending = GlobalVariables.getSendMML();
            sendNoMML.setSelected(!sending);
            sendMML.setSelected(sending);

            // V3 MML Version and Sending
            String val = GlobalVariables.getMMLVersion();
            if (val != null && val.startsWith("2")) {
                mml23.setSelected(true);
            } else {
                mml3.setSelected(true);
            }

            // 送信先
            val = GlobalVariables.getUploaderIPAddress();
            if (val != null && !val.equals("")) {
                uploaderServer.setText(val);
            }

            // 送信ディレクトリ
            val = GlobalVariables.getUploadShareDirectory();
            if (val != null && !val.equals("")) {
                shareDirectory.setText(val);
            }

            connect();
        }

        public void restore() {
            // センター送信
            boolean b = sendMML.isSelected();
            GlobalVariables.setSendMML(b);

            // MML バージョン
            String val = mml3.isSelected() ? "300" : "230";
            GlobalVariables.setMMLVersion(val);

            // アップローダアドレス
            val = uploaderServer.getText().trim();
            if (!val.equals("")) {
                GlobalVariables.setUploaderIPAddress(val);
            }

            // 共有ディレクトリ
            val = shareDirectory.getText().trim();
            if (!val.equals("")) {
                GlobalVariables.setUploadShareDirectory(val);
            }
        }
    }

    class StateMgr {

        public void checkState() {

            State newState = isValid()
                    ? State.VALID_STATE
                    : State.INVALID_STATE;
            if (newState != state) {
                setState(newState);
            }
        }

        public void controlSendMml() {
            boolean b = sendMML.isSelected();
            mml3.setEnabled(b);
            mml23.setEnabled(b);
            protocolCombo.setEnabled(b);
            uploaderServer.setEnabled(b);
            shareDirectory.setEnabled(b);
            this.checkState();
        }

        protected boolean isValid() {
            if (sendMML.isSelected()) {
                boolean uploadAddrOk = (uploaderServer.getText().trim().equals("") == false) ? true : false;
                boolean shareOk = (shareDirectory.getText().trim().equals("") == false) ? true : false;

                return (uploadAddrOk && shareOk) ? true : false;
            } else {
                return true;
            }
        }
    }
}
