/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CodeHelperSettingPanel.java
 *
 * Created on 2010/03/09, 11:54:11
 */
package open.dolphin.client.settings;

import open.dolphin.project.GlobalConstants;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import open.dolphin.helper.GridBagBuilder;
import open.dolphin.infomodel.IInfoModel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import open.dolphin.client.AbstractCodeHelper;
import open.dolphin.utils.Adapter;

/**
 *
 * @author
 */
public class CodeHelperSettingPanel extends javax.swing.JPanel implements IAbstractSettingPanel {

    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    private State state = State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "codeHelperSetting";
    private static final String TITLE = "コード";
    private static final String ICON = "help_24.gif";
    private JRadioButton ctrlMask;
    private JRadioButton metaMask;
    private JTextField text;
    private JTextField path;
    private JTextField general;
    private JTextField other;
    private JTextField treatment;
    private JTextField surgery;
    private JTextField radiology;
    private JTextField labo;
    private JTextField physiology;
    private JTextField injection;
    private JTextField rp;
    private JTextField baseCharge;
    private JTextField instraction;
    private JTextField stay_on_home;
    private JTextField orca;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JLabel label8;
    private JLabel label9;
    private JLabel label10;
    private JLabel label11;
    private JLabel label12;
    private JLabel label13;
    private JLabel label14;
    private JLabel label15;
    private JLabel label16;
    private JPanel keyBind;
    private JPanel stamp;
    private State curState = State.NONE_STATE;
    private HelperModel model;
    private Adapter<Boolean, Boolean> adapter;

    /** Creates new form CodeHelperSettingPanel */
    public CodeHelperSettingPanel() {
        boundSupport = new PropertyChangeSupport(this);        
        initComponents();
        setLayout(new GridBagLayout());
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
        model = new HelperModel();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
   
    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }
    /**
     * GUI を生成しプログラムを開始する。
     */
    public void start() {
        initCustomComponents();
        model.populate();
        connect();
        checkState();
    }

    /**
     * 保存する。
     */
    public void save() {
        model.restore();
    }

    /**
     * GUI を構築する
     */
    private void initCustomComponents() {

        ctrlMask = new JRadioButton("コントロール");
        String str = GlobalConstants.isMac() ? "アップル" : "メタ";
        metaMask = new JRadioButton(str);
        text = new JTextField(5);
        path = new JTextField(5);
        general = new JTextField(5);
        other = new JTextField(5);
        treatment = new JTextField(5);
        surgery = new JTextField(5);
        radiology = new JTextField(5);
        labo = new JTextField(5);
        physiology = new JTextField(5);
        injection = new JTextField(5);
        rp = new JTextField(5);
        baseCharge = new JTextField(5);
        instraction = new JTextField(5);
        stay_on_home = new JTextField(5);
        orca = new JTextField(5);

        //
        // 修飾キー
        //
        keyBind = new JPanel(new BorderLayout());
        GridBagBuilder gbl = new GridBagBuilder(keyBind, "修飾キー + スペース = 補完ポップアップ");

        label1 = new JLabel("修飾キー:");
        gbl.add(label1, 0, 0, GridBagConstraints.EAST);

        JPanel p1 = new JPanel(new FlowLayout(FlowLayout.LEFT, 5, 0));
        p1.add(ctrlMask);
        p1.add(metaMask);
        gbl.add(p1, 1, 0, GridBagConstraints.CENTER);

        // Stamptree
        stamp = new JPanel(new BorderLayout());
        gbl = new GridBagBuilder(stamp, "スタンプ箱のキーワード");

        label2 = new JLabel("テキスト:");
        gbl.add(label2, 0, 0, GridBagConstraints.EAST);
        gbl.add(text, 1, 0, GridBagConstraints.WEST);
        label3 = new JLabel("パス:");
        gbl.add(label3, 2, 0, GridBagConstraints.EAST);
        gbl.add(path, 3, 0, GridBagConstraints.WEST);
        label4 = new JLabel("汎 用:");
        gbl.add(label4, 0, 1, GridBagConstraints.EAST);
        gbl.add(general, 1, 1, GridBagConstraints.WEST);
        label5 = new JLabel("その他:");
        gbl.add(label5, 2, 1, GridBagConstraints.EAST);
        gbl.add(other, 3, 1, GridBagConstraints.WEST);
        label6 = new JLabel("処 置:");
        gbl.add(label6, 0, 2, GridBagConstraints.EAST);
        gbl.add(treatment, 1, 2, GridBagConstraints.WEST);
        label7 = new JLabel("手 術:");
        gbl.add(label7, 2, 2, GridBagConstraints.EAST);
        gbl.add(surgery, 3, 2, GridBagConstraints.WEST);
        label8 = new JLabel("画像診断:");
        gbl.add(label8, 0, 3, GridBagConstraints.EAST);
        gbl.add(radiology, 1, 3, GridBagConstraints.WEST);
        label9 = new JLabel("検体検査:");
        gbl.add(label9, 2, 3, GridBagConstraints.EAST);
        gbl.add(labo, 3, 3, GridBagConstraints.WEST);
        label10 = new JLabel("生体検査:");
        gbl.add(label10, 0, 4, GridBagConstraints.EAST);
        gbl.add(physiology, 1, 4, GridBagConstraints.WEST);
        label11 = new JLabel("注 射:");
        gbl.add(label11, 0, 5, GridBagConstraints.EAST);
        gbl.add(injection, 1, 5, GridBagConstraints.WEST);
        label12 = new JLabel("処 方:");
        gbl.add(label12, 2, 5, GridBagConstraints.EAST);
        gbl.add(rp, 3, 5, GridBagConstraints.WEST);
        label13 = new JLabel("診断料:");
        gbl.add(label13, 0, 6, GridBagConstraints.EAST);
        gbl.add(baseCharge, 1, 6, GridBagConstraints.WEST);
        label14 = new JLabel("指導:");
        gbl.add(label14, 2, 6, GridBagConstraints.EAST);
        gbl.add(instraction, 3, 6, GridBagConstraints.WEST);
        label15 = new JLabel("在宅:");
        gbl.add(label15, 0, 7, GridBagConstraints.EAST);
        gbl.add(stay_on_home, 1, 7, GridBagConstraints.WEST);
        label16 = new JLabel("ORCA:");
        gbl.add(label16, 2, 7, GridBagConstraints.EAST);
        gbl.add(orca, 3, 7, GridBagConstraints.WEST);

        // 全体をレイアウトする
        //    setPanel(new JPanel(new GridBagLayout()));
        gbl = new GridBagBuilder(this);
        gbl.add(keyBind, 0, 0, GridBagConstraints.HORIZONTAL, 1.0, 0.0);
        gbl.add(stamp, 0, 1, GridBagConstraints.HORIZONTAL, 1.0, 0.0);
        gbl.add(new JLabel(""), 0, 2, GridBagConstraints.BOTH, 1.0, 1.0);

    }

    private void connect() {

        ButtonGroup bg = new ButtonGroup();
        bg.add(ctrlMask);
        bg.add(metaMask);

        DocumentListener dl = new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                checkState();
            }

            public void removeUpdate(DocumentEvent e) {
                checkState();
            }

            public void changedUpdate(DocumentEvent e) {
                checkState();
            }
        };

        text.getDocument().addDocumentListener(dl);
        path.getDocument().addDocumentListener(dl);
        general.getDocument().addDocumentListener(dl);
        other.getDocument().addDocumentListener(dl);
        treatment.getDocument().addDocumentListener(dl);
        surgery.getDocument().addDocumentListener(dl);
        radiology.getDocument().addDocumentListener(dl);
        labo.getDocument().addDocumentListener(dl);
        physiology.getDocument().addDocumentListener(dl);
        injection.getDocument().addDocumentListener(dl);
        rp.getDocument().addDocumentListener(dl);
        baseCharge.getDocument().addDocumentListener(dl);
        instraction.getDocument().addDocumentListener(dl);
        stay_on_home.getDocument().addDocumentListener(dl);
        orca.getDocument().addDocumentListener(dl);

    }

    private void checkState() {

        State newState = State.NONE_STATE;

        if (text.getText().trim().equals("") ||
                path.getText().trim().equals("") ||
                general.getText().trim().equals("") ||
                other.getText().trim().equals("") ||
                treatment.getText().trim().equals("") ||
                surgery.getText().trim().equals("") ||
                radiology.getText().trim().equals("") ||
                labo.getText().trim().equals("") ||
                physiology.getText().trim().equals("") ||
                injection.getText().trim().equals("") ||
                injection.getText().trim().equals("") ||
                rp.getText().trim().equals("") ||
                baseCharge.getText().trim().equals("") ||
                instraction.getText().trim().equals("") ||
                stay_on_home.getText().trim().equals("") ||
                orca.getText().trim().equals("")) {

            newState = State.INVALID_STATE;

        } else {
            newState = State.VALID_STATE;
        }

        if (curState != newState) {
            curState = newState;
            setState(curState);
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    /**
     *
     * @return
     */
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ProjectSettingDialog getContext() {
        return context;
    }

    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener(STATE_PROP, context);
        this.setLogInState(context.getLoginState());
    }

    public boolean isLoginState() {
        return loginState;
    }

    public void setLogInState(boolean login) {
        loginState = login;
    }

    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    /**
     * @param state The state to set.
     */
    public void setState(State state) {
        this.state = state;
        boundSupport.firePropertyChange(STATE_PROP, null, this.state);
    }

    /**
     * @return Returns the state.
     */
    public State getState() {
        return state;
    }

    class HelperModel {

        /**
         * 設定した値をプレファレンスに保存する。
         */
        public void restore() {
            Preferences prefs = Preferences.userNodeForPackage(AbstractCodeHelper.class);

            String mask = ctrlMask.isSelected() ? "ctrl" : "meta";

            prefs.put("modifier", mask);
            prefs.put(IInfoModel.ENTITY_TEXT, text.getText().trim());
            prefs.put(IInfoModel.ENTITY_PATH, path.getText().trim());
            prefs.put(IInfoModel.ENTITY_GENERAL_ORDER, general.getText().trim());
            prefs.put(IInfoModel.ENTITY_OTHER_ORDER, other.getText().trim());
            prefs.put(IInfoModel.ENTITY_TREATMENT, treatment.getText().trim());
            prefs.put(IInfoModel.ENTITY_SURGERY_ORDER, surgery.getText().trim());
            prefs.put(IInfoModel.ENTITY_RADIOLOGY_ORDER, radiology.getText().trim());
            prefs.put(IInfoModel.ENTITY_LABO_TEST, labo.getText().trim());
            prefs.put(IInfoModel.ENTITY_PHYSIOLOGY_ORDER, physiology.getText().trim());
            prefs.put(IInfoModel.ENTITY_INJECTION_ORDER, injection.getText().trim());
            prefs.put(IInfoModel.ENTITY_MED_ORDER, rp.getText().trim());
            prefs.put(IInfoModel.ENTITY_BASE_CHARGE_ORDER, baseCharge.getText().trim());
            prefs.put(IInfoModel.ENTITY_INSTRACTION_CHARGE_ORDER, instraction.getText().trim());
            prefs.put(IInfoModel.ENTITY_STAY_ON_HOME_CHARGE_ORDER, stay_on_home.getText().trim());
            prefs.put(IInfoModel.ENTITY_ORCA, orca.getText().trim());
        }

        /**
         * プレファレンスから値をGUIにセットする。
         */
        private void populate() {

            Preferences prefs = Preferences.userNodeForPackage(AbstractCodeHelper.class);

            String mask = GlobalConstants.isMac() ? "meta" : "ctrl";
            String modifier = prefs.get("modifier", mask);

            if (modifier.equals("ctrl")) {
                ctrlMask.setSelected(true);
                metaMask.setSelected(false);
            } else {
                ctrlMask.setSelected(false);
                metaMask.setSelected(true);
            }

            text.setText(prefs.get(IInfoModel.ENTITY_TEXT, "tx").trim());
            path.setText(prefs.get(IInfoModel.ENTITY_PATH, "pat").trim());
            general.setText(prefs.get(IInfoModel.ENTITY_GENERAL_ORDER, "gen").trim());
            other.setText(prefs.get(IInfoModel.ENTITY_OTHER_ORDER, "oth").trim());
            treatment.setText(prefs.get(IInfoModel.ENTITY_TREATMENT, "tr").trim());
            surgery.setText(prefs.get(IInfoModel.ENTITY_SURGERY_ORDER, "sur").trim());
            radiology.setText(prefs.get(IInfoModel.ENTITY_RADIOLOGY_ORDER, "rad").trim());
            labo.setText(prefs.get(IInfoModel.ENTITY_LABO_TEST, "lab").trim());
            physiology.setText(prefs.get(IInfoModel.ENTITY_PHYSIOLOGY_ORDER, "phy").trim());
            injection.setText(prefs.get(IInfoModel.ENTITY_INJECTION_ORDER, "inj").trim());
            rp.setText(prefs.get(IInfoModel.ENTITY_MED_ORDER, "rp").trim());
            baseCharge.setText(prefs.get(IInfoModel.ENTITY_BASE_CHARGE_ORDER, "base").trim());
            instraction.setText(prefs.get(IInfoModel.ENTITY_INSTRACTION_CHARGE_ORDER, "ins").trim());
            stay_on_home.setText(prefs.get(IInfoModel.ENTITY_STAY_ON_HOME_CHARGE_ORDER, "sty").trim());
            orca.setText(prefs.get(IInfoModel.ENTITY_ORCA, "orca").trim());
        }
    }
}
