/*
 * ConfigView.java
 *
 * Created on 2007/12/10, 18:50
 */
package open.dolphin.client.settings;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import open.dolphin.project.GlobalConstants;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.ResourceMap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;

import open.dolphin.client.imagebrowserdocument.ImageBrowserDocumentPanel;
import open.dolphin.log.LogWriter;
import open.dolphin.utils.Adapter;

/**
 *
 * @author  kazm
 */
public class BrowserSettingPanel extends javax.swing.JPanel implements IAbstractSettingPanel {

    private ProjectSettingDialog context;
    private PropertyChangeSupport boundSupport;
    /**
     *
     */
    protected State state = State.NONE_STATE;
    private boolean loginState;
    private String title;
    private String icon;
    private String id;
    private static final String ID = "imageBrowserSetting";
    private static final String TITLE = "画像";
    private static final String ICON = "Picture.png";
    private ApplicationContext appCtx;
    private Properties properties;
    private Adapter<Boolean, Boolean> adapter;

    /** Creates new form ConfigView */
    public BrowserSettingPanel() {
        boundSupport = new PropertyChangeSupport(this);
        initComponents();
        this.setId(ID);
        this.setTitle(TITLE);
        this.setIcon(ICON);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        dicomFld = new javax.swing.JTextField();
        pdfFld = new javax.swing.JTextField();
        jpegFld = new javax.swing.JTextField();
        jpegBtn = new javax.swing.JButton();
        pdfBtn = new javax.swing.JButton();
        dicomBtn = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        baseDirFld = new javax.swing.JTextField();
        baseDirBtn = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        columnSpinner = new javax.swing.JSpinner();
        jLabel6 = new javax.swing.JLabel();
        fileNameChkBox = new javax.swing.JCheckBox();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("画像フォーマットと起動アプリケーション"));

        jLabel2.setText("PDF:");

        jLabel1.setText("JPEG:");

        jLabel3.setText("DICOM:");

        dicomFld.setEditable(false);
        dicomFld.setText("/Applications/ImageJ/ImageJ.app");
        dicomFld.setToolTipText("DICOM画像を表示するアプリケーションを示します。");
        dicomFld.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                dicomFldPropertyChange(evt);
            }
        });

        pdfFld.setEditable(false);
        pdfFld.setToolTipText("PDF文書を表示するアプリケーションを示します。");
        pdfFld.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                pdfFldPropertyChange(evt);
            }
        });

        jpegFld.setEditable(false);
        jpegFld.setToolTipText("JPEG画像を表示するアプリケーションを示します。");
        jpegFld.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                jpegFldPropertyChange(evt);
            }
        });

        jpegBtn.setText("設定...");
        jpegBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jpegBtnActionPerformed(evt);
            }
        });

        pdfBtn.setText("設定...");
        pdfBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pdfBtnActionPerformed(evt);
            }
        });

        dicomBtn.setText("設定...");
        dicomBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dicomBtnActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(jLabel2)
                    .add(jLabel1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jpegFld, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, pdfFld, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                    .add(dicomFld, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jpegBtn)
                    .add(pdfBtn)
                    .add(dicomBtn)))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jpegBtn)
                    .add(jpegFld, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(9, 9, 9)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(pdfBtn)
                    .add(pdfFld, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(dicomBtn)
                    .add(dicomFld, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("画像・PDF文書の場所"));

        jLabel4.setText("ベースディレクトリ:");

        baseDirFld.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                baseDirFldPropertyChange(evt);
            }
        });

        baseDirBtn.setText("設定...");
        baseDirBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                baseDirBtnActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel4)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(baseDirFld, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 331, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(baseDirBtn))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(baseDirFld, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(baseDirBtn))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("表示"));

        jLabel5.setText("画像テーブルのカラム数:");

        columnSpinner.setModel(new javax.swing.SpinnerNumberModel(5, 1, 10, 1));
        columnSpinner.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                columnSpinnerPropertyChange(evt);
            }
        });

        jLabel6.setText("ファイル名表示:");

        fileNameChkBox.setText("有");
        fileNameChkBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                fileNameChkBoxStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel5)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(columnSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(jLabel6)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(fileNameChkBox)
                .addContainerGap(199, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(columnSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel6)
                    .add(fileNameChkBox))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(10, 10, 10)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(10, 10, 10)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void baseDirBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_baseDirBtnActionPerformed
        setBaseDirectory();
    }//GEN-LAST:event_baseDirBtnActionPerformed

    private void jpegBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jpegBtnActionPerformed
        setJepgView();
    }//GEN-LAST:event_jpegBtnActionPerformed

    private void pdfBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pdfBtnActionPerformed
        setPdfView();
    }//GEN-LAST:event_pdfBtnActionPerformed

    private void dicomBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dicomBtnActionPerformed
        setDicomView();
    }//GEN-LAST:event_dicomBtnActionPerformed

    private void columnSpinnerPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_columnSpinnerPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_columnSpinnerPropertyChange

    private void fileNameChkBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_fileNameChkBoxStateChanged

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_fileNameChkBoxStateChanged

    private void baseDirFldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_baseDirFldPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_baseDirFldPropertyChange

    private void jpegFldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jpegFldPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_jpegFldPropertyChange

    private void pdfFldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_pdfFldPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_pdfFldPropertyChange

    private void dicomFldPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_dicomFldPropertyChange

        if (adapter != null) {
            try {
                adapter.onResult(true);
            } catch (Exception ex) {
                LogWriter.error(getClass(), ex);
            }
        }

    }//GEN-LAST:event_dicomFldPropertyChange
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton baseDirBtn;
    private javax.swing.JTextField baseDirFld;
    private javax.swing.JSpinner columnSpinner;
    private javax.swing.JButton dicomBtn;
    private javax.swing.JTextField dicomFld;
    private javax.swing.JCheckBox fileNameChkBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JButton jpegBtn;
    private javax.swing.JTextField jpegFld;
    private javax.swing.JButton pdfBtn;
    private javax.swing.JTextField pdfFld;
    // End of variables declaration//GEN-END:variables

    @Override
    public void onChenge(Adapter<Boolean, Boolean> adapter) {
        this.adapter = adapter;
    }

    private String selectApp() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            String app = chooser.getSelectedFile().getPath();
            return app;
        }
        return null;
    }

    @Action
    public void setBaseDirectory() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            String dir = chooser.getSelectedFile().getPath();
            baseDirFld.setText(dir);
        }
    }

    @Action
    public void setJepgView() {
        String app = selectApp();
        if (app != null) {
            jpegFld.setText(app);
        }
    }

    /**
     *
     */
    @Action
    public void setPdfView() {
        String app = selectApp();
        if (app != null) {
            pdfFld.setText(app);
        }
    }

    @Action
    public void setDicomView() {
        String app = selectApp();
        if (app != null) {
            dicomFld.setText(app);
        }
    }

    @Action
    public void saveProperties() {

        String spiVal = columnSpinner.getValue().toString();
        properties.setProperty("columnCount", spiVal);

        String boolVal = String.valueOf(fileNameChkBox.isSelected());
        properties.setProperty("showFileName", boolVal);

        String baseVal = baseDirFld.getText().trim();
        properties.setProperty("baseDir", baseVal);

        properties.setProperty("jpegView", jpegFld.getText().trim());
        properties.setProperty("pdfView", pdfFld.getText().trim());
        properties.setProperty("dicomView", dicomFld.getText().trim());

        LocalStorage ls = appCtx.getLocalStorage();
        try {
            ls.save(properties, "imageBrowserProp.xml");
        } catch (IOException ex) {
            LogWriter.error(getClass(), ex);

        }
    }

    @Action
    public void cancel() {
    }

    @Override
    public void start() {
        loadResources();
        initCustomComponents();
    }

    private void initCustomComponents() {

        String spiVal = properties.getProperty("columnCount");
        int spiInt = Integer.parseInt(spiVal);
        columnSpinner.setValue(new Integer(spiInt));

        Boolean boolVal = Boolean.parseBoolean(properties.getProperty("showFileName"));
        fileNameChkBox.setSelected(boolVal.booleanValue());

        String baseDir = properties.getProperty("baseDir");
        baseDirFld.setText(baseDir);

        jpegFld.setText(properties.getProperty("jpegView"));
        pdfFld.setText(properties.getProperty("pdfView"));
        dicomFld.setText(properties.getProperty("dicomView"));
    }

    private void loadResources() {
        appCtx = GlobalConstants.getApplicationContext();
        //     ActionMap map = appCtx.getActionMap(BrowserSettingPanel.this);
        ResourceMap resource = appCtx.getResourceMap(ImageBrowserDocumentPanel.class);

        try {
            LocalStorage ls = appCtx.getLocalStorage();
            properties = (Properties) ls.load("imageBrowserProp.xml");
        } catch (Exception e) {
            LogWriter.error(getClass(), e);
        }

        if (properties == null) {
            properties = new Properties();
            properties.setProperty("columnCount", "5");
            properties.setProperty("showFileName", "true");
            properties.setProperty("baseDir", "");
            if (GlobalConstants.isMac()) {
                String jpegView = resource.getString("jpegView.mac");
                if (jpegView == null) {
                    jpegView = "";
                }
                properties.setProperty("jpegView", jpegView);
                String pdfView = resource.getString("pdfView.mac");
                if (pdfView == null) {
                    pdfView = "";
                }
                properties.setProperty("pdfView", pdfView);
            } else if (GlobalConstants.isWin()) {
                String jpegView = resource.getString("jpegView.win");
                if (jpegView == null) {
                    jpegView = "";
                }
                properties.setProperty("jpegView", jpegView);
                String pdfView = resource.getString("pdfView.win");
                if (pdfView == null) {
                    pdfView = "";
                }
                properties.setProperty("pdfView", pdfView);
            } else {
                properties.setProperty("jpegView", "");
                properties.setProperty("pdfView", "");
            }
            properties.setProperty("dicomView", "");
        }
    }

    @Override
    public void save() {
        saveProperties();
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getIcon() {
        return icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public ProjectSettingDialog getContext() {
        return context;
    }

    @Override
    public void setContext(ProjectSettingDialog context) {
        this.context = context;
        this.addPropertyChangeListener(STATE_PROP, context);
        this.setLogInState(context.getLoginState());
    }

    @Override
    public boolean isLoginState() {
        return loginState;
    }

    @Override
    public void setLogInState(boolean login) {
        loginState = login;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
        boundSupport.removePropertyChangeListener(prop, l);
    }

    /**
     * @param state The state to set.
     */
    @Override
    public void setState(State state) {
        this.state = state;
        boundSupport.firePropertyChange(STATE_PROP, null, this.state);
    }

    /**
     * @return Returns the state.
     */
    @Override
    public State getState() {
        return state;
    }
}
