
package open.dolphin.client.labotestimporter;

import java.util.ArrayList;
import java.util.List;

/**
 *
 *
 */
public class LaboTestInformation {
    private String centerCode;
    private String requestKey;
    private String sampleTime;
    private String reportTime;

    private String patientId;
    private String patientIdType;
    private String patientIdTypeTableId;
    private String moduleUUID;
    private String confirmedDate;

    private String registId;
    private String reportStatus;
    private String reportStatusCode;
    private String reportStatusCodeType;

    private String clientFacility;
    private String clientFacilityCode;
    private String clientFacilityCodeId;

    private String laboratoryCenter;
    private String laboratoryCenterCode;
    private String laboratoryCenterCodeId;

    private String specimenName;
    private String specimenCode;
    private String specimenCodeId;

    private String commitionedKey;
    private String patiantName;
    private String status;

    private String milk;

    private String hemolytic;
    private String bilirubin;

    private String registTime;

    private String abnormalValueFlag;
    private List<String> abnormalValues;

    private List<LaboTestResultInformation> laboTestResultInformations;

    private List<AverageInformation> averageInformations;

    public LaboTestInformation() {
        laboTestResultInformations = new ArrayList<LaboTestResultInformation>();
        abnormalValues = new ArrayList<String>();
        averageInformations = new ArrayList<AverageInformation>();
    }

    public int laboTestResultInformationSize() {
        return this.laboTestResultInformations.size();
    }

    public int averageInformationSize() {
        return this.averageInformations.size();
    }

    public void addTestResultInformation(LaboTestResultInformation testResultInformation) {
        this.laboTestResultInformations.add(testResultInformation);
    }

    public LaboTestResultInformation getLaboTestResultInformation(int index) {
        return this.laboTestResultInformations.get(index);
    }

    /**
     *
     * @param abnormalValue
     */
    public void addAbnormalValue(String abnormalValue) {
        this.abnormalValues.add(abnormalValue);
    }

    /**
     *
     * @param index
     * @return
     */
    public String getAbnormalValue(int index) {
        return this.abnormalValues.get(index);
    }

    public void addAverageInformation(AverageInformation averageInformation) {
        this.averageInformations.add(averageInformation);
    }

    public AverageInformation getAverageInformation(int index) {
        return this.averageInformations.get(index);
    }

    public String getConfirmedDate() {
        return confirmedDate;
    }

    public void setConfirmedDate(String confirmedDate) {
        this.confirmedDate = confirmedDate;
    }

    public String getModuleUUID() {
        return moduleUUID;
    }

    public void setModuleUUID(String moduleUUID) {
        this.moduleUUID = moduleUUID;
    }

    public String getPatientId() {
        return patientId;
    }

    public void setPatientId(String patientId) {
        this.patientId = patientId;
    }

    public String getPatientIdType() {
        return patientIdType;
    }

    public void setPatientIdType(String patientIdType) {
        this.patientIdType = patientIdType;
    }

    public String getPatientIdTypeTableId() {
        return patientIdTypeTableId;
    }

    public void setPatientIdTypeTableId(String patientIdTypeTableId) {
        this.patientIdTypeTableId = patientIdTypeTableId;
    }

    public String getClientFacility() {
        return clientFacility;
    }

    public void setClientFacility(String clientFacility) {
        this.clientFacility = clientFacility;
    }

    public String getClientFacilityCode() {
        return clientFacilityCode;
    }

    public void setClientFacilityCode(String clientFacilityCode) {
        this.clientFacilityCode = clientFacilityCode;
    }

    /**
     *
     * @return
     */
    public String getClientFacilityCodeId() {
        return clientFacilityCodeId;
    }

    public void setClientFacilityCodeId(String clientFacilityCodeId) {
        this.clientFacilityCodeId = clientFacilityCodeId;
    }

    public String getRegistId() {
        return registId;
    }

    public void setRegistId(String registId) {
        this.registId = registId;
    }

    public String getReportStatus() {
        return reportStatus;
    }

    public void setReportStatus(String reportStatus) {
        this.reportStatus = reportStatus;
    }

    public String getReportStatusCode() {
        return reportStatusCode;
    }

    /**
     *
     * @param reportStatusCode
     */
    public void setReportStatusCode(String reportStatusCode) {
        this.reportStatusCode = reportStatusCode;
    }

    public String getReportStatusCodeType() {
        return reportStatusCodeType;
    }

    public void setReportStatusCodeType(String reportStatusCodeType) {
        this.reportStatusCodeType = reportStatusCodeType;
    }

    public String getLaboratoryCenter() {
        return laboratoryCenter;
    }

    /**
     *
     * @param laboratoryCenter
     */
    public void setLaboratoryCenter(String laboratoryCenter) {
        this.laboratoryCenter = laboratoryCenter;
    }

    public String getLaboratoryCenterCode() {
        return laboratoryCenterCode;
    }

    /**
     *
     * @param laboratoryCenterCode
     */
    public void setLaboratoryCenterCode(String laboratoryCenterCode) {
        this.laboratoryCenterCode = laboratoryCenterCode;
    }

    /**
     *
     * @return
     */
    public String getLaboratoryCenterCodeId() {
        return laboratoryCenterCodeId;
    }

    public void setLaboratoryCenterCodeId(String laboratoryCenterCodeId) {
        this.laboratoryCenterCodeId = laboratoryCenterCodeId;
    }

    public String getReportTime() {
        return reportTime;
    }

    public void setReportTime(String reportTime) {
        this.reportTime = reportTime.trim();
    }

    public String getSampleTime() {
        return sampleTime;
    }

    public void setSampleTime(String sampleTime) {
        this.sampleTime = sampleTime.trim();
    }

    public String getMilk() {
        return milk;
    }

    public void setMilk(String milk) {
        this.milk = milk.trim();
    }

    /**
     *
     * @return
     */
    public String getAbnormalValueFlag() {
        return abnormalValueFlag;
    }

    /**
     *
     * @param abnormalValueFlag
     */
    public void setAbnormalValueFlag(String abnormalValueFlag) {
        this.abnormalValueFlag = abnormalValueFlag.trim();
    }

    public String getRegistTime() {
        return registTime;
    }

    public void setRegistTime(String registTime) {
        this.registTime = registTime.trim();
    }

    public String getBilirubin() {
        return bilirubin;
    }

    public void setBilirubin(String bilirubin) {
        this.bilirubin = bilirubin.trim();
    }

    public String getCenterCode() {
        return centerCode;
    }

    public void setCenterCode(String centerCode) {
        this.centerCode = centerCode.trim();
    }

    public String getCommitionedKey() {
        return commitionedKey;
    }

    public void setCommitionedKey(String commitionedKey) {
        this.commitionedKey = commitionedKey.trim();
    }

    public String getHemolytic() {
        return hemolytic;
    }

    public void setHemolytic(String hemolytic) {
        this.hemolytic = hemolytic.trim();
    }

    /**
     *
     * @return
     */
    public String getPatiantName() {
        return patiantName;
    }

    public void setPatiantName(String patiantName) {
        this.patiantName = patiantName.trim();
    }

    public String getRequestKey() {
        return requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey.trim();
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status.trim();
    }

    public String getSpecimenCode() {
        return specimenCode;
    }

    /**
     *
     * @param specimenCode
     */
    public void setSpecimenCode(String specimenCode) {
        this.specimenCode = specimenCode;
    }

    public String getSpecimenCodeId() {
        return specimenCodeId;
    }

    public void setSpecimenCodeId(String specimenCodeId) {
        this.specimenCodeId = specimenCodeId;
    }

    public String getSpecimenName() {
        return specimenName;
    }

    /**
     *
     * @param specimenName
     */
    public void setSpecimenName(String specimenName) {
        this.specimenName = specimenName;
    }

}
