/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import [Ljava.lang.Number;;
import fr.apteryx.imageio.dicom.Constants;
import fr.apteryx.imageio.dicom.DataSet;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.Util;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.IndexColorModel;
import java.util.HashMap;

abstract class DicomColorSpace
implements Constants {
    private static HashMap hash = new HashMap();
    private static HashMap h;

    DicomColorSpace() {
    }

    static String getDicomType(ColorSpace colorSpace) throws DicomException {
        switch (colorSpace.getType()) {
            case 5: {
                return "RGB";
            }
            case 3: {
                return colorSpace instanceof YbrPartial ? "YBR_PARTIAL_422" : (colorSpace instanceof YbrICT ? "YBR_ICT" : (colorSpace instanceof YbrRCT ? "YBR_RCT" : "YBR_FULL"));
            }
            case 9: {
                return "CMYK";
            }
            case 7: {
                return "HSV";
            }
        }
        throw new DicomException("Unsupported", "Colorspace");
    }

    static synchronized String tagToIIOStandard(String string) {
        if (h == null) {
            h = new HashMap();
            h.put("MONOCHROME1", "GRAY");
            h.put("MONOCHROME2", "GRAY");
            h.put("PALETTE COLOR", "RGB");
            h.put("RGB", "RGB");
            h.put("HSV", "HSV");
            h.put("ARGB", "4CLR");
            h.put("CMYK", "CMYK");
            h.put("YBR_FULL", "YCbCr");
            h.put("YBR_FULL_422", "YCbCr");
            h.put("YBR_PARTIAL_422", "YCbCr");
            h.put("YBR_PARTIAL_420", "YCbCr");
            h.put("YBR_ICT", "YCbCr");
            h.put("YBR_RCT", "YCbCr");
        }
        return (String)h.get(string);
    }

    static synchronized ColorSpace getInstance(String string, int n) {
        ColorSpace colorSpace;
        if (string == null) {
            switch (n) {
                case 1: {
                    string = "MONOCHROME2";
                    break;
                }
                case 3: {
                    string = "RGB";
                    break;
                }
                case 4: {
                    string = "CMYK";
                }
            }
        }
        if ((colorSpace = (ColorSpace)hash.get(string)) != null) {
            return colorSpace;
        }
        if (string.equals("MONOCHROME2")) {
            colorSpace = ColorSpace.getInstance(1003);
        } else if (string.equals("MONOCHROME1")) {
            colorSpace = new Monochrome1();
        } else if (string.equals("YBR_FULL") || string.equals("YBR_FULL_422")) {
            colorSpace = new YbrFull();
        } else if (string.equals("YBR_PARTIAL_422") || string.equals("YBR_PARTIAL_420")) {
            colorSpace = new YbrPartial();
        } else if (string.equals("YBR_ICT")) {
            colorSpace = new YbrICT();
        } else if (string.equals("YBR_RCT")) {
            colorSpace = new YbrRCT();
        } else if (string.equals("CMYK")) {
            try {
                colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance("CMYK.pf"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            colorSpace = ColorSpace.getInstance(1000);
        }
        hash.put(string, colorSpace);
        return colorSpace;
    }

    static ColorSpace getInstanceFromPresentationLUTShape(String string) {
        String string2 = "INVERSE".equals(string) ? "MONOCHROME1" : "MONOCHROME2";
        return DicomColorSpace.getInstance(string2, 1);
    }

    static ColorSpace getInstanceFromPresentationLUTSequence(DataSet dataSet) {
        Number[] numberArray = (Number[])dataSet.findValue(2633730, Number;.class);
        if (numberArray == null || numberArray.length != 3) {
            return null;
        }
        int n = numberArray[2].intValue();
        short[] sArray = Util.toShortArray(dataSet.findValue(2633734));
        if (sArray == null) {
            return null;
        }
        return new PresentationLUT(sArray, n);
    }

    private static final void clamp(float[] fArray) {
        if (fArray[0] < 0.0f) {
            fArray[0] = 0.0f;
        }
        if (fArray[1] < 0.0f) {
            fArray[1] = 0.0f;
        }
        if (fArray[2] < 0.0f) {
            fArray[2] = 0.0f;
        }
        if (fArray[0] > 1.0f) {
            fArray[0] = 1.0f;
        }
        if (fArray[1] > 1.0f) {
            fArray[1] = 1.0f;
        }
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
    }

    private static final void clamp2(float[] fArray) {
        if (fArray[0] < 0.0f) {
            fArray[0] = 0.0f;
        }
        if (fArray[1] < -0.5f) {
            fArray[1] = -0.5f;
        }
        if (fArray[2] < -0.5f) {
            fArray[2] = -0.5f;
        }
        if (fArray[0] > 1.0f) {
            fArray[0] = 1.0f;
        }
        if (fArray[1] > 0.5f) {
            fArray[1] = 0.5f;
        }
        if (fArray[2] > 0.5f) {
            fArray[2] = 0.5f;
        }
    }

    private static final void clamp3(float[] fArray) {
        if (fArray[0] < 0.0f) {
            fArray[0] = 0.0f;
        }
        if (fArray[1] < -1.0f) {
            fArray[1] = -1.0f;
        }
        if (fArray[2] < -1.0f) {
            fArray[2] = -1.0f;
        }
        if (fArray[0] > 1.0f) {
            fArray[0] = 1.0f;
        }
        if (fArray[1] > 1.0f) {
            fArray[1] = 1.0f;
        }
        if (fArray[2] > 1.0f) {
            fArray[2] = 1.0f;
        }
    }

    static IndexColorModel getIndexColorModel(int n, Number[][] numberArray, short[][] sArray) throws DicomException {
        int n2;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        byte[][] byArrayArray = new byte[3][];
        for (n2 = 0; n2 < 3; ++n2) {
            if (numberArray[n2] == null || sArray[n2] == null) {
                throw new DicomException("ProtocoleViolation", "Invalid palette data");
            }
            nArray[n2] = numberArray[n2][0].shortValue() & 0xFFFF;
            if (nArray[n2] == 0) {
                nArray[n2] = 65536;
            }
            nArray2[n2] = numberArray[n2][1].shortValue() & 0xFFFF;
            nArray3[n2] = numberArray[n2][2].intValue();
        }
        n2 = 1 << n;
        for (int i = 0; i < 3; ++i) {
            int n3;
            int n4;
            byte by;
            int n5;
            short[] sArray2 = sArray[i];
            byArrayArray[i] = new byte[n2];
            byte[] byArray = byArrayArray[i];
            int n6 = nArray2[i];
            if (n6 > n2) {
                n6 = n2;
            }
            if (n6 + (n5 = sArray2.length) > n2) {
                n5 = n2 - n6;
            }
            if (nArray3[i] <= 8) {
                by = (byte)sArray2[0];
                for (n4 = n6 - 1; n4 >= 0; --n4) {
                    byArray[n4] = by;
                }
                for (n4 = n5 - 1; n4 >= 0; --n4) {
                    byArray[n6 + n4] = (byte)sArray2[n4];
                }
                if (n6 + n5 >= n2) continue;
                n4 = (byte)sArray2[sArray2.length - 1];
                for (n3 = n6 + n5; n3 < n2; ++n3) {
                    byArray[n3] = n4;
                }
                continue;
            }
            by = (byte)(sArray2[0] >> 8);
            for (n4 = n6 - 1; n4 >= 0; --n4) {
                byArray[n4] = by;
            }
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                byArray[n6 + n4] = (byte)(sArray2[n4] >> 8);
            }
            if (n6 + n5 >= n2) continue;
            n4 = (byte)(sArray2[sArray2.length - 1] >> 8);
            for (n3 = n6 + n5; n3 < n2; ++n3) {
                byArray[n3] = n4;
            }
        }
        return new IndexColorModel(n, n2, byArrayArray[0], byArrayArray[1], byArrayArray[2]);
    }

    static final class YbrRCT
    extends ColorSpace {
        YbrRCT() {
            super(3, 3);
        }

        public float[] fromCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] fromRGB(float[] fArray) {
            float[] fArray2 = new float[]{(fArray[0] + 2.0f * fArray[1] + fArray[2]) / 4.0f, fArray[2] - fArray[1], fArray[0] - fArray[1]};
            DicomColorSpace.clamp3(fArray2);
            return fArray2;
        }

        public String getName(int n) {
            switch (n) {
                case 0: {
                    return "Y";
                }
                case 1: {
                    return "Cb";
                }
            }
            return "Cr";
        }

        public float[] toCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] toRGB(float[] fArray) {
            float[] fArray2 = new float[3];
            fArray2[1] = fArray[0] - (fArray[1] + fArray[2]) / 4.0f;
            fArray2[0] = fArray[2] + fArray2[1];
            fArray2[2] = fArray[1] + fArray2[1];
            DicomColorSpace.clamp(fArray2);
            return fArray2;
        }

        public float getMinValue(int n) {
            return n == 0 ? 0.0f : -1.0f;
        }
    }

    static final class YbrICT
    extends ColorSpace {
        YbrICT() {
            super(3, 3);
        }

        public float[] fromCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] fromRGB(float[] fArray) {
            float[] fArray2 = new float[]{0.299f * fArray[0] + 0.587f * fArray[1] + 0.114f * fArray[2], -0.16875f * fArray[0] - 0.33126f * fArray[1] + 0.5f * fArray[2], 0.5f * fArray[0] - 0.41869f * fArray[1] - 0.08131f * fArray[2]};
            DicomColorSpace.clamp2(fArray2);
            return fArray2;
        }

        public String getName(int n) {
            switch (n) {
                case 0: {
                    return "Y";
                }
                case 1: {
                    return "Cb";
                }
            }
            return "Cr";
        }

        public float[] toCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] toRGB(float[] fArray) {
            float[] fArray2 = new float[]{fArray[0] + 1.402f * fArray[2], fArray[0] - 0.34413f * fArray[1] - 0.71414f * fArray[2], fArray[0] + 1.772f * fArray[1]};
            DicomColorSpace.clamp(fArray2);
            return fArray2;
        }

        public float getMinValue(int n) {
            return n == 0 ? 0.0f : -0.5f;
        }

        public float getMaxValue(int n) {
            return n == 0 ? 1.0f : 0.5f;
        }
    }

    static final class YbrPartial
    extends ColorSpace {
        YbrPartial() {
            super(3, 3);
        }

        public float[] fromCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] fromRGB(float[] fArray) {
            float[] fArray2 = new float[]{0.0625f + 0.2568f * fArray[0] + 0.5041f * fArray[1] + 0.0979f * fArray[2], 0.5f - 0.1482f * fArray[0] - 0.291f * fArray[1] + 0.4392f * fArray[2], 0.5f + 0.4392f * fArray[0] - 0.3678f * fArray[1] - 0.0714f * fArray[2]};
            DicomColorSpace.clamp(fArray2);
            return fArray2;
        }

        public String getName(int n) {
            switch (n) {
                case 0: {
                    return "Y";
                }
                case 1: {
                    return "Cb";
                }
            }
            return "Cr";
        }

        public float[] toCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] toRGB(float[] fArray) {
            float[] fArray2 = new float[]{1.16442f * fArray[0] - 1.0E-4f * fArray[1] + 1.596f * fArray[2] - 0.8707262f, 1.16442f * fArray[0] - 0.39172f * fArray[1] - 0.81301f * fArray[2] + 0.52959f, 1.16442f * fArray[0] + 2.01729f * fArray[1] - 1.4E-4f * fArray[2] - 1.0813513f};
            DicomColorSpace.clamp(fArray2);
            return fArray2;
        }
    }

    static final class YbrFull
    extends ColorSpace {
        YbrFull() {
            super(3, 3);
        }

        public float[] fromCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] fromRGB(float[] fArray) {
            float[] fArray2 = new float[]{0.299f * fArray[0] + 0.587f * fArray[1] + 0.114f * fArray[2], 0.5f - 0.1687f * fArray[0] - 0.3313f * fArray[1] + 0.5f * fArray[2], 0.5f + 0.5f * fArray[0] - 0.4187f * fArray[1] - 0.0813f * fArray[2]};
            DicomColorSpace.clamp(fArray2);
            return fArray2;
        }

        public String getName(int n) {
            switch (n) {
                case 0: {
                    return "Y";
                }
                case 1: {
                    return "Cb";
                }
            }
            return "Cr";
        }

        public float[] toCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] toRGB(float[] fArray) {
            float[] fArray2 = new float[]{fArray[0] + 1.40199f * fArray[2] - 0.700995f, fArray[0] - 0.34411f * fArray[1] - 0.7141f * fArray[2] + 0.529105f, fArray[0] + 1.77198f * fArray[1] - 0.88599f};
            DicomColorSpace.clamp(fArray2);
            return fArray2;
        }
    }

    static final class PresentationLUT
    extends ColorSpace {
        private final short[] data;
        private final int out_max;
        private final int in_len;

        PresentationLUT(short[] sArray, int n) {
            super(6, 1);
            this.data = sArray;
            this.out_max = (1 << n) - 1;
            this.in_len = sArray.length;
        }

        public float[] fromCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] fromRGB(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public String getName(int n) {
            return "Gray";
        }

        public float[] toCIEXYZ(float[] fArray) {
            throw new RuntimeException("Unsupported");
        }

        public float[] toRGB(float[] fArray) {
            float f;
            int n = (int)(fArray[0] * (float)this.in_len);
            if (n >= this.in_len) {
                n = this.in_len - 1;
            }
            if ((f = (float)(this.data[n] & 0xFFFF) / (float)this.out_max) > 1.0f) {
                f = 1.0f;
            }
            return new float[]{f, f, f};
        }
    }

    static final class Monochrome1
    extends ColorSpace {
        static final ColorSpace css = Monochrome1.getInstance(1003);

        Monochrome1() {
            super(6, 1);
        }

        public float[] fromCIEXYZ(float[] fArray) {
            float[] fArray2 = css.fromCIEXYZ(fArray);
            fArray2[0] = 1.0f - fArray2[0];
            return fArray2;
        }

        public float[] fromRGB(float[] fArray) {
            float f = 3.0f - (fArray[0] + fArray[1] + fArray[2]);
            return new float[]{f > 3.0f ? 1.0f : (f < 0.0f ? 0.0f : f / 3.0f)};
        }

        public String getName(int n) {
            return "Gray";
        }

        public float[] toCIEXYZ(float[] fArray) {
            float[] fArray2 = new float[]{1.0f - fArray[0]};
            return css.toCIEXYZ(fArray2);
        }

        public float[] toRGB(float[] fArray) {
            float f = 1.0f - fArray[0];
            return new float[]{f, f, f};
        }
    }
}

