/*
 * Decompiled with CFR 0.152.
 */
package fr.apteryx.imageio.dicom;

import fr.apteryx.imageio.dicom.CounterImageOutputStream;
import fr.apteryx.imageio.dicom.DataElement;
import fr.apteryx.imageio.dicom.DataSetWriter;
import fr.apteryx.imageio.dicom.DicomException;
import fr.apteryx.imageio.dicom.DicomWriter;
import fr.apteryx.imageio.dicom.Plugin;
import fr.apteryx.imageio.dicom.TransferSyntax;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import javax.imageio.stream.ImageOutputStream;

public class DataSet
extends TreeMap {
    transient long offset;
    static Comparator comparator = new Comp();

    final void add(DataElement dataElement) {
        this.put(new Integer(dataElement.tag), dataElement);
    }

    public DataSet() {
        super(comparator);
    }

    final void write(ImageOutputStream imageOutputStream, TransferSyntax transferSyntax, boolean bl, DicomWriter dicomWriter, boolean bl2) throws DicomException, IOException {
        new DataSetWriter(imageOutputStream, transferSyntax, this, bl, dicomWriter, bl2).write();
    }

    final int getLength() {
        CounterImageOutputStream counterImageOutputStream = new CounterImageOutputStream();
        try {
            new DataSetWriter(counterImageOutputStream, TransferSyntax.IMPLICIT_LITTLEENDIAN, this, true, null, false).write();
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        return counterImageOutputStream.getCounter();
    }

    public final void add(int n, Object object) {
        this.add(new DataElement(n, object));
    }

    public final void add(int n, int n2) {
        this.add(new DataElement(n, new Integer(n2)));
    }

    public final void add(int n, long l) {
        this.add(new DataElement(n, new Long(l)));
    }

    public final void add(int n, float f) {
        this.add(new DataElement(n, new Float(f)));
    }

    public final void add(int n, double d) {
        this.add(new DataElement(n, new Double(d)));
    }

    public final void remove(int n) {
        this.remove(new Integer(n));
    }

    final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append(((DataElement)iterator.next()).toString(string));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    final DataElement find(int n) {
        return (DataElement)this.get(new Integer(n));
    }

    public final boolean has(int n) {
        return this.containsKey(new Integer(n));
    }

    public final Object findValue(int n) {
        return this.findValue(n, Object.class);
    }

    final Object findValue(int n, Class clazz) {
        DataElement dataElement = this.find(n);
        return dataElement == null || !clazz.isInstance(dataElement.value) ? null : dataElement.value;
    }

    public String findString(int n) {
        DataElement dataElement = this.find(n);
        return dataElement == null || dataElement.value == null ? null : dataElement.value.toString();
    }

    public int findInt(int n) {
        DataElement dataElement = this.find(n);
        if (dataElement != null && dataElement.value instanceof Number) {
            return ((Number)dataElement.value).intValue();
        }
        return 0;
    }

    public float findFloat(int n) {
        DataElement dataElement = this.find(n);
        if (dataElement != null && dataElement.value instanceof Number) {
            return ((Number)dataElement.value).floatValue();
        }
        return 0.0f;
    }

    public double findDouble(int n) {
        DataElement dataElement = this.find(n);
        if (dataElement != null && dataElement.value instanceof Number) {
            return ((Number)dataElement.value).doubleValue();
        }
        return 0.0;
    }

    public DataSet findDataSet(int n) {
        DataElement dataElement = this.find(n);
        if (dataElement == null) {
            return null;
        }
        Object object = dataElement.value;
        if (object instanceof Collection && ((Collection)object).size() == 1) {
            object = ((Collection)object).iterator().next();
        }
        if (object instanceof DataSet) {
            return (DataSet)object;
        }
        return null;
    }

    public Collection findSequence(int n) {
        DataElement dataElement = this.find(n);
        if (dataElement != null) {
            Object object = dataElement.value;
            if (object instanceof Collection) {
                return (Collection)object;
            }
            if (object instanceof DataSet) {
                ArrayList<Object> arrayList = new ArrayList<Object>(1);
                arrayList.add(object);
                return arrayList;
            }
        }
        return null;
    }

    public long findLong(int n) {
        DataElement dataElement = this.find(n);
        if (dataElement != null && dataElement.value instanceof Number) {
            return ((Number)dataElement.value).longValue();
        }
        return 0L;
    }

    public void removeUnwritableElements() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            DataElement dataElement = (DataElement)iterator.next();
            String string = dataElement.getVR();
            if (string == null) {
                iterator.remove();
                continue;
            }
            if (!string.equals("SQ")) continue;
            if (dataElement.value instanceof DataSet) {
                ((DataSet)dataElement.value).removeUnwritableElements();
                continue;
            }
            if (!(dataElement.value instanceof Collection)) continue;
            Iterator iterator2 = ((Collection)dataElement.value).iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof DataSet)) continue;
                ((DataSet)e).removeUnwritableElements();
            }
        }
    }

    void checkSpecificCharacterSet() {
        if (this.findString(524293) == null && Plugin.specificCharacterSet != null) {
            this.add(524293, Plugin.specificCharacterSet);
        }
    }

    static class Comp
    implements Serializable,
    Comparator {
        Comp() {
        }

        public final int compare(Object object, Object object2) {
            return ((long)((Integer)object).intValue() & 0xFFFFFFFFL) < ((long)((Integer)object2).intValue() & 0xFFFFFFFFL) ? -1 : (object.equals(object2) ? 0 : 1);
        }
    }
}

