/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Template;

class TemplateImpl
implements Template {
    public static final Template TID_2010 = new TemplateImpl("2010", "DCMR", null, null);
    private static final int MEANING_PROMPT_LEN = 20;
    private final String templateIdentifier;
    private final String mappingResource;
    private final Long templateVersion;
    private final Long templateLocalVersion;

    public TemplateImpl(String templateIdentifier, String mappingResource, Date templateVersion, Date templateLocalVersion) {
        this.templateIdentifier = templateIdentifier;
        if (this.templateIdentifier.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mappingResource = mappingResource;
        if (this.mappingResource.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.templateVersion = templateVersion != null ? new Long(templateVersion.getTime()) : null;
        this.templateLocalVersion = templateLocalVersion != null ? new Long(templateLocalVersion.getTime()) : null;
    }

    public TemplateImpl(Dataset ds) throws DcmValueException {
        this(ds.getString(4250368), ds.getString(524549), ds.getDate(4250374), ds.getDate(4250375));
    }

    public static Template newTemplate(Dataset ds) throws DcmValueException {
        return ds != null ? new TemplateImpl(ds) : null;
    }

    public String getTemplateIdentifier() {
        return this.templateIdentifier;
    }

    public String getMappingResource() {
        return this.mappingResource;
    }

    public Date getTemplateVersion() {
        return this.templateVersion != null ? new Date(this.templateVersion) : null;
    }

    public Date getTemplateLocalVersion() {
        return this.templateLocalVersion != null ? new Date(this.templateLocalVersion) : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TemplateImpl)) {
            return false;
        }
        TemplateImpl o = (TemplateImpl)obj;
        if (!this.templateIdentifier.equals(o.templateIdentifier)) {
            return false;
        }
        if (!this.mappingResource.equals(o.mappingResource)) {
            return false;
        }
        if (this.templateVersion == null ? o.templateVersion != null : !this.templateVersion.equals(o.templateVersion)) {
            return false;
        }
        return !(this.templateLocalVersion == null ? o.templateLocalVersion != null : !this.templateLocalVersion.equals(o.templateVersion));
    }

    public int hashCode() {
        return this.templateIdentifier.hashCode();
    }

    public String toString() {
        return "TID" + this.templateIdentifier + "@" + this.mappingResource;
    }

    public void toDataset(Dataset ds) {
        ds.putCS(4250368, this.templateIdentifier);
        ds.putCS(524549, this.mappingResource);
        if (this.templateVersion != null) {
            ds.putDT(4250374, new Date(this.templateVersion));
        }
        if (this.templateLocalVersion != null) {
            ds.putDT(4250375, new Date(this.templateLocalVersion));
            ds.putCS(4250379, "Y");
        }
    }
}

