/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.IOException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.media.DirRecord;

final class DirRecordImpl
implements DirRecord {
    private static final DcmObjectFactory factory = DcmObjectFactory.getInstance();
    final DcmParser parser;
    final Dataset dataset;
    final int pos;
    int next;
    int lower;
    String type;
    int inUse;
    String[] refFileIDs;
    String refSOPClassUID;
    String refSOPInstanceUID;
    String refTransferSyntaxUID;
    long inUsePos;
    long nextValPos;
    long lowerValPos;

    public DirRecordImpl(DcmParser parser, int pos) throws IOException {
        this.parser = parser;
        this.dataset = factory.newDataset();
        this.pos = pos;
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException, DcmValueException {
        this.parser.seek((long)this.pos & 0xFFFFFFFFL);
        this.parser.setDcmHandler(this.dataset.getDcmHandler());
        try {
            this.parser.parseItemDataset();
        }
        finally {
            this.parser.setDcmHandler(null);
        }
        this.type = this.dataset.getString(267312, null);
        if (this.type == null) {
            throw new DcmValueException("Missing Directory Record Type");
        }
        DcmElement nextElem = this.dataset.get(267264);
        if (nextElem == null || nextElem.isEmpty()) {
            throw new DcmValueException("Missing Offset of Referenced Next Directory Record");
        }
        this.next = nextElem.getInt();
        this.nextValPos = nextElem.getStreamPosition() + 8L;
        DcmElement inUseElem = this.dataset.get(267280);
        if (inUseElem == null || inUseElem.isEmpty()) {
            throw new DcmValueException("Missing Record In-use Flag");
        }
        this.inUse = inUseElem.getInt();
        this.inUsePos = inUseElem.getStreamPosition() + 8L;
        DcmElement lowerElem = this.dataset.get(267296);
        if (lowerElem == null || lowerElem.isEmpty()) {
            throw new DcmValueException("Missing Offset of Referenced Lower-Level Directory Entity");
        }
        this.lower = lowerElem.getInt();
        this.lowerValPos = lowerElem.getStreamPosition() + 8L;
        this.refFileIDs = this.dataset.getStrings(267520);
        this.refSOPClassUID = this.dataset.getString(267536, null);
        this.refSOPInstanceUID = this.dataset.getString(267537, null);
        this.refTransferSyntaxUID = this.dataset.getString(267538, null);
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public String getType() {
        return this.type;
    }

    public int getInUseFlag() {
        return this.inUse;
    }

    public String[] getRefFileIDs() {
        return this.refFileIDs;
    }

    public String getRefSOPClassUID() {
        return this.refSOPClassUID;
    }

    public String getRefSOPInstanceUID() {
        return this.refSOPInstanceUID;
    }

    public String getRefSOPTransferSyntaxUID() {
        return this.refTransferSyntaxUID;
    }

    public String toString() {
        return "DirRecord[inUse:" + this.inUse + ",type:" + this.type + ",next: " + this.next + ",lower: " + this.lower + "]";
    }

    public DirRecord getNextSibling() throws IOException {
        return this.getNextSibling(true);
    }

    public DirRecord getNextSibling(boolean onlyInUse) throws IOException {
        if (this.next == 0) {
            return null;
        }
        DirRecordImpl retval = new DirRecordImpl(this.parser, this.next);
        if (onlyInUse && retval.getInUseFlag() == 0) {
            return retval.getNextSibling(onlyInUse);
        }
        return retval;
    }

    public DirRecord getFirstChild() throws IOException {
        return this.getFirstChild(true);
    }

    public DirRecord getFirstChild(boolean onlyInUse) throws IOException {
        if (this.lower == 0) {
            return null;
        }
        DirRecordImpl retval = new DirRecordImpl(this.parser, this.lower);
        if (onlyInUse && retval.getInUseFlag() == 0) {
            return retval.getNextSibling(onlyInUse);
        }
        return retval;
    }

    public boolean match(String type, Dataset keys, boolean ignorePNCase) {
        return (type == null || type.equals(this.type)) && this.dataset.match(keys, ignorePNCase, true);
    }

    public DirRecord getFirstChildBy(String type, Dataset keys, boolean ignorePNCase) throws IOException {
        DirRecord dr = this.getFirstChild(true);
        return dr == null || dr.match(type, keys, ignorePNCase) ? dr : dr.getNextSiblingBy(type, keys, ignorePNCase);
    }

    public DirRecord getNextSiblingBy(String type, Dataset keys, boolean ignorePNCase) throws IOException {
        DirRecord dr = this;
        while ((dr = dr.getNextSibling(true)) != null && !dr.match(type, keys, ignorePNCase)) {
        }
        return dr;
    }
}

