/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.dcm4cheri.image.ConfigurationException;
import org.dcm4cheri.image.ConfigurationUtils;

public class ImageReaderFactory {
    private static final ImageReaderFactory instance = new ImageReaderFactory();
    private final Properties map = new Properties();

    public static final ImageReaderFactory getInstance() {
        return instance;
    }

    private ImageReaderFactory() {
        ConfigurationUtils.loadPropertiesForClass(this.map, ImageReaderFactory.class);
    }

    public ImageReader getReaderForTransferSyntax(String tsuid) {
        String s = this.map.getProperty(tsuid);
        if (s == null) {
            throw new UnsupportedOperationException("No Image Reader available for Transfer Syntax:" + tsuid);
        }
        int delim = s.indexOf(44);
        if (delim == -1) {
            throw new ConfigurationException("Missing ',' in " + tsuid + "=" + s);
        }
        String formatName = s.substring(0, delim);
        String className = s.substring(delim + 1);
        Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName(formatName);
        while (it.hasNext()) {
            ImageReader r = it.next();
            if (!className.equals(r.getClass().getName())) continue;
            return r;
        }
        throw new ConfigurationException("No Image Reader of class " + className + " available for format:" + formatName);
    }
}

